/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;

public class TernaryNode
implements Expression {
    private Expression<Boolean> condition;
    private Expression trueExpression;
    private Expression falseExpression;

    public TernaryNode(Expression<Boolean> condition, Expression trueExpression, Expression falseExpression) {
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public Object eval(Function context) {
        Boolean conditionResult = this.condition.eval(context);
        if (conditionResult == null) {
            throw new EvaluationException("Ternary condition is null");
        }
        return conditionResult != false ? this.trueExpression.eval(context) : this.falseExpression.eval(context);
    }

    public String toString() {
        return "(" + this.condition + " ? " + this.trueExpression + " : " + this.falseExpression + ")";
    }
}

