/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.PropertyHolder;
import org.noear.solon.expression.snel.ReflectionUtil;
import org.noear.solon.expression.snel.SafeNavigationNode;

public class PropertyNode
implements Expression {
    private final Expression target;
    private final Expression property;
    private boolean safe = false;
    private PropertyHolder propertyCached;

    public PropertyNode(Expression target, String property) {
        this(target, (Expression)new ConstantNode(property));
    }

    public PropertyNode(Expression target, Expression property) {
        this.target = target;
        this.property = property;
    }

    public PropertyNode(SafeNavigationNode target, Expression property) {
        this(target.getTarget(), property);
        this.safe = true;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public Object eval(Function context) {
        Object targetValue = this.target.eval(context);
        if (targetValue == null) {
            return null;
        }
        Object propertyValue = this.property.eval(context);
        if (propertyValue == null) {
            return null;
        }
        if (targetValue instanceof List && propertyValue instanceof Number) {
            int index = ((Number)propertyValue).intValue();
            try {
                return ((List)targetValue).get(index);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (targetValue.getClass().isArray() && propertyValue instanceof Number) {
            int index = ((Number)propertyValue).intValue();
            try {
                return Array.get(targetValue, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
        String propName = propertyValue.toString();
        if (targetValue instanceof Map) {
            return ((Map)targetValue).get(propName);
        }
        return this.getPropertyValue(targetValue, propName);
    }

    public Expression getTarget() {
        return this.target;
    }

    public String getPropertyName() {
        if (this.property instanceof ConstantNode) {
            return ((ConstantNode)this.property).getValue().toString();
        }
        throw new EvaluationException("Invalid property name: " + this.property);
    }

    private Object getPropertyValue(Object target, String propName) {
        if (this.propertyCached == null) {
            this.propertyCached = ReflectionUtil.getProperty(target.getClass(), propName);
        }
        try {
            return this.propertyCached.getValue(target);
        }
        catch (Throwable e) {
            throw new EvaluationException("Failed to access property: " + propName, e);
        }
    }

    public String toString() {
        if (this.safe) {
            return this.target + "?.[" + this.property + "]";
        }
        return this.target + "[" + this.property + "]";
    }
}

