/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.context.StandardContext;
import org.noear.solon.expression.snel.SnEL;
import org.noear.solon.expression.snel.TemplateFragment;
import org.noear.solon.expression.snel.TemplateMarker;

public class TemplateNode
implements Expression<String> {
    private final List<TemplateFragment> fragments;
    private TemplateFragment constantFragment;

    public TemplateNode(List<TemplateFragment> fragments) {
        this.fragments = fragments;
        if (fragments.size() == 1 && fragments.get(0).getMarker() == TemplateMarker.TEXT) {
            this.constantFragment = fragments.get(0);
        }
    }

    @Override
    public String eval(Function context) {
        if (this.constantFragment != null) {
            return this.constantFragment.getContent();
        }
        StringBuilder result = new StringBuilder();
        for (TemplateFragment fragment : this.fragments) {
            if (fragment.getMarker() == TemplateMarker.TEXT) {
                result.append(fragment.getContent());
                continue;
            }
            Object value = fragment.getMarker() == TemplateMarker.PROPERTIES ? this.getProps(fragment, context) : SnEL.eval(fragment.getContent(), context);
            result.append(value);
        }
        return result.toString();
    }

    private String getProps(TemplateFragment expr, Function context) {
        Object props = null;
        if (context instanceof StandardContext) {
            props = ((StandardContext)context).properties();
        }
        if (props == null) {
            props = context;
        }
        String value = null;
        if (props instanceof Properties) {
            value = ((Properties)props).getProperty(expr.getPropertyKey());
        } else if (props instanceof Function) {
            Object tmp = ((Function)props).apply(expr.getPropertyKey());
            if (tmp != null) {
                value = String.valueOf(tmp);
            }
        } else {
            throw new IllegalArgumentException("Unsupported props type: " + props.getClass());
        }
        if (value == null) {
            return expr.getPropertyDef();
        }
        return value;
    }
}

