/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Parser;
import org.noear.solon.expression.exception.CompilationException;
import org.noear.solon.expression.snel.ArithmeticNode;
import org.noear.solon.expression.snel.ArithmeticOp;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ComparisonOp;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.ElvisNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.LogicalOp;
import org.noear.solon.expression.snel.MethodNode;
import org.noear.solon.expression.snel.PropertyNode;
import org.noear.solon.expression.snel.SafeNavigationNode;
import org.noear.solon.expression.snel.TemplateFragment;
import org.noear.solon.expression.snel.TemplateMarker;
import org.noear.solon.expression.snel.TemplateNode;
import org.noear.solon.expression.snel.TernaryNode;
import org.noear.solon.expression.snel.VariableNode;
import org.noear.solon.expression.util.LRUCache;

public class SnelEvaluateParser
implements Parser {
    private static final SnelEvaluateParser INSTANCE = new SnelEvaluateParser(1000);
    private final Map<String, Expression> exprCached;

    public static SnelEvaluateParser getInstance() {
        return INSTANCE;
    }

    public SnelEvaluateParser(int cahceCapacity) {
        this.exprCached = Collections.synchronizedMap(new LRUCache(cahceCapacity));
    }

    public Expression parse(String expr, boolean cached) {
        if (cached) {
            return this.exprCached.computeIfAbsent(expr, this::parseDo);
        }
        return this.parseDo(expr);
    }

    protected Expression parseDo(String expr) {
        if (this.isPropertyExpression(expr)) {
            return this.parsePropertyExpression(expr);
        }
        ParserState state = new ParserState(expr);
        Expression result = this.parseElvisExpression(state);
        if (state.getCurrentChar() != -1) {
            throw new CompilationException("Unexpected trailing character: " + (char)state.getCurrentChar());
        }
        return result;
    }

    private Expression parseElvisExpression(ParserState state) {
        Expression left = this.parseTernaryExpression(state);
        state.skipWhitespace();
        if (state.getCurrentChar() == 63 && state.peekNextChar() == 58) {
            state.nextChar();
            state.nextChar();
            Expression right = this.parseElvisExpression(state);
            return new ElvisNode(left, right);
        }
        return left;
    }

    private Expression parseSafeNavigationExpression(ParserState state) {
        Expression left = this.parsePrimaryExpression(state);
        while (state.getCurrentChar() == 63 && state.peekNextChar() == 46) {
            state.nextChar();
            state.nextChar();
            state.skipWhitespace();
            String identifier = this.parseIdentifier(state);
            left = new SafeNavigationNode(left, identifier);
            left = this.parsePostfixAfterSafeNavigation(state, left);
        }
        return left;
    }

    private Expression parsePostfixAfterSafeNavigation(ParserState state, Expression expr) {
        while (true) {
            state.skipWhitespace();
            if (this.eat(state, '(')) {
                List<Expression> args = this.parseMethodArguments(state);
                this.require(state, ')', "Expected ')' after arguments");
                expr = new MethodNode((SafeNavigationNode)expr, args);
                continue;
            }
            if (!this.eat(state, '[')) break;
            Expression indexExpr = this.parseLogicalOrExpression(state);
            this.require(state, ']', "Expected ']' after index");
            expr = new PropertyNode((SafeNavigationNode)expr, indexExpr);
        }
        return expr;
    }

    private boolean isPropertyExpression(String expr) {
        return expr.startsWith("${") && expr.endsWith("}");
    }

    private Expression parsePropertyExpression(String expr) {
        String content = expr.substring(2, expr.length() - 1);
        ArrayList<TemplateFragment> fragments = new ArrayList<TemplateFragment>();
        fragments.add(new TemplateFragment(TemplateMarker.PROPERTIES, content));
        return new TemplateNode(fragments);
    }

    private Expression parseTernaryExpression(ParserState state) {
        Expression condition = this.parseLogicalOrExpression(state);
        state.skipWhitespace();
        if (state.getCurrentChar() == 63 && state.peekNextChar() != 46 && state.peekNextChar() != 58) {
            state.nextChar();
            state.skipWhitespace();
            Expression trueExpr = this.parseTernaryExpression(state);
            this.require(state, ':', "Expected ':' in ternary expression");
            Expression falseExpr = this.parseTernaryExpression(state);
            return new TernaryNode(condition, trueExpr, falseExpr);
        }
        return condition;
    }

    private Expression parseLogicalOrExpression(ParserState state) {
        Expression left = this.parseLogicalAndExpression(state);
        state.skipWhitespace();
        while (this.eat(state, "OR") || this.eat(state, "||")) {
            left = new LogicalNode(LogicalOp.OR, left, this.parseLogicalAndExpression(state));
        }
        return left;
    }

    private Expression parseLogicalAndExpression(ParserState state) {
        Expression left = this.parseLogicalNotExpression(state);
        state.skipWhitespace();
        while (this.eat(state, "AND") || this.eat(state, "&&")) {
            left = new LogicalNode(LogicalOp.AND, left, this.parseLogicalNotExpression(state));
        }
        return left;
    }

    private Expression parseLogicalNotExpression(ParserState state) {
        if (this.eat(state, "NOT") || this.eat(state, "!")) {
            return new LogicalNode(LogicalOp.NOT, this.parseComparisonExpression(state), null);
        }
        return this.parseComparisonExpression(state);
    }

    private Expression parseComparisonExpression(ParserState state) {
        Expression left = this.parseAdditiveExpression(state);
        state.skipWhitespace();
        if (this.isComparisonOperatorStart(state.getCurrentChar())) {
            String op = this.parseComparisonOperator(state);
            return new ComparisonNode(ComparisonOp.parse(op), left, this.parseAdditiveExpression(state));
        }
        if (this.eat(state, "IN")) {
            return new ComparisonNode(ComparisonOp.in, left, this.parseListExpression(state));
        }
        if (this.eat(state, "LIKE")) {
            return new ComparisonNode(ComparisonOp.lk, left, this.parseAdditiveExpression(state));
        }
        if (this.eat(state, "NOT")) {
            if (this.eat(state, "IN")) {
                return new ComparisonNode(ComparisonOp.nin, left, this.parseListExpression(state));
            }
            if (this.eat(state, "LIKE")) {
                return new ComparisonNode(ComparisonOp.nlk, left, this.parseAdditiveExpression(state));
            }
            throw new CompilationException("Invalid NOT expression");
        }
        return left;
    }

    private Expression parseAdditiveExpression(ParserState state) {
        Expression left = this.parseMultiplicativeExpression(state);
        while (true) {
            if (this.eat(state, '+')) {
                left = new ArithmeticNode(ArithmeticOp.ADD, left, this.parseMultiplicativeExpression(state));
                continue;
            }
            if (!this.eat(state, '-')) break;
            left = new ArithmeticNode(ArithmeticOp.SUB, left, this.parseMultiplicativeExpression(state));
        }
        return left;
    }

    private Expression parseMultiplicativeExpression(ParserState state) {
        Expression left = this.parseSafeNavigationExpression(state);
        while (true) {
            if (this.eat(state, '*')) {
                left = new ArithmeticNode(ArithmeticOp.MUL, left, this.parseSafeNavigationExpression(state));
                continue;
            }
            if (this.eat(state, '/')) {
                left = new ArithmeticNode(ArithmeticOp.DIV, left, this.parseSafeNavigationExpression(state));
                continue;
            }
            if (!this.eat(state, '%')) break;
            left = new ArithmeticNode(ArithmeticOp.MOD, left, this.parseSafeNavigationExpression(state));
        }
        return left;
    }

    private Expression parsePrimaryExpression(ParserState state) {
        Expression expr;
        state.skipWhitespace();
        if (state.getCurrentChar() == 36 && state.peekNextChar() == 123) {
            String propertyExpr = this.parsePropertyExpression(state);
            expr = this.parsePropertyExpression(propertyExpr);
        } else if (this.eat(state, '(')) {
            expr = this.parseElvisExpression(state);
            this.require(state, ')', "Expected ')' after expression");
        } else if (state.isNumber()) {
            expr = new ConstantNode(this.parseNumber(state));
        } else if (state.isString()) {
            expr = new ConstantNode(this.parseString(state));
        } else if (state.isArray()) {
            expr = this.parseListExpression(state);
        } else if (this.checkKeyword(state, "true")) {
            expr = new ConstantNode(true);
        } else if (this.checkKeyword(state, "false")) {
            expr = new ConstantNode(false);
        } else if (this.checkKeyword(state, "null")) {
            expr = new ConstantNode(null);
        } else {
            String identifier = this.parseIdentifier(state);
            expr = new VariableNode(identifier);
        }
        return this.parsePostfix(state, expr);
    }

    private String parsePropertyExpression(ParserState state) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)state.getCurrentChar());
        state.nextChar();
        sb.append((char)state.getCurrentChar());
        state.nextChar();
        int braceCount = 1;
        while (state.getCurrentChar() != -1 && braceCount > 0) {
            char c = (char)state.getCurrentChar();
            sb.append(c);
            state.nextChar();
            if (c == '{') {
                ++braceCount;
                continue;
            }
            if (c != '}') continue;
            --braceCount;
        }
        return sb.toString();
    }

    private Expression parsePostfix(ParserState state, Expression expr) {
        block4: {
            while (true) {
                state.skipWhitespace();
                if (this.eat(state, '.')) {
                    String prop = this.parseIdentifier(state);
                    expr = new PropertyNode(expr, prop);
                    continue;
                }
                if (this.eat(state, '[')) {
                    Expression indexExpr = this.parseLogicalOrExpression(state);
                    this.require(state, ']', "Expected ']' after index");
                    expr = new PropertyNode(expr, indexExpr);
                    continue;
                }
                if (!this.eat(state, '(')) break block4;
                List<Expression> args = this.parseMethodArguments(state);
                this.require(state, ')', "Expected ')' after arguments");
                if (expr instanceof PropertyNode) {
                    PropertyNode propNode = (PropertyNode)expr;
                    expr = new MethodNode(propNode.getTarget(), propNode.getPropertyName(), args);
                    continue;
                }
                if (!(expr instanceof VariableNode)) break;
                VariableNode varNode = (VariableNode)expr;
                expr = new MethodNode(varNode, varNode.getName(), args);
            }
            throw new CompilationException("Invalid method call target: " + expr);
        }
        return expr;
    }

    private Expression parseVariableOrMethodCall(ParserState state) {
        Expression expr;
        block4: {
            String identifier = this.parseIdentifier(state);
            expr = new VariableNode(identifier);
            while (true) {
                state.skipWhitespace();
                if (this.eat(state, '.')) {
                    String prop = this.parseIdentifier(state);
                    expr = new PropertyNode(expr, prop);
                    continue;
                }
                if (this.eat(state, '[')) {
                    Expression propExpr = this.parseLogicalOrExpression(state);
                    this.eat(state, ']');
                    expr = new PropertyNode(expr, propExpr);
                    continue;
                }
                if (!this.eat(state, '(')) break block4;
                List<Expression> args = this.parseMethodArguments(state);
                this.eat(state, ')');
                if (expr instanceof PropertyNode) {
                    PropertyNode propertyNode = (PropertyNode)expr;
                    expr = new MethodNode(propertyNode.getTarget(), propertyNode.getPropertyName(), args);
                    continue;
                }
                if (!(expr instanceof VariableNode)) break;
                expr = new MethodNode(expr, identifier, args);
            }
            throw new CompilationException("Invalid method call target: " + expr);
        }
        return expr;
    }

    private List<Expression> parseMethodArguments(ParserState state) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        while (state.getCurrentChar() != 41) {
            args.add(this.parseLogicalOrExpression(state));
            if (!this.eat(state, ',')) continue;
        }
        return args;
    }

    private boolean isComparisonOperatorStart(int c) {
        return c == 62 || c == 60 || c == 61 || c == 33;
    }

    private String parseComparisonOperator(ParserState state) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)state.getCurrentChar());
        state.nextChar();
        if (state.getCurrentChar() == 61) {
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        return sb.toString();
    }

    private Expression parseListExpression(ParserState state) {
        if (this.eat(state, '[')) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (state.getCurrentChar() != 93) {
                list.add(this.parseValue(state));
                if (!this.eat(state, ',')) continue;
            }
            this.eat(state, ']');
            return new ConstantNode(list);
        }
        return this.parseTernaryExpression(state);
    }

    private Object parseValue(ParserState state) {
        state.skipWhitespace();
        if (state.isString()) {
            return this.parseString(state);
        }
        if (state.isNumber()) {
            return this.parseNumber(state);
        }
        if (this.checkKeyword(state, "true")) {
            return true;
        }
        if (this.checkKeyword(state, "false")) {
            return false;
        }
        if (this.checkKeyword(state, "null")) {
            return null;
        }
        return this.parseVariableOrMethodCall(state);
    }

    private String parseString(ParserState state) {
        char quote = (char)state.getCurrentChar();
        state.nextChar();
        StringBuilder sb = new StringBuilder();
        while (state.getCurrentChar() != quote) {
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        state.nextChar();
        return sb.toString();
    }

    private Number parseNumber(ParserState state) {
        StringBuilder sb = new StringBuilder();
        boolean isFloat = false;
        boolean isDouble = false;
        boolean isLong = false;
        while (state.isNumber() || state.getCurrentChar() == 46) {
            char c2;
            if (state.getCurrentChar() == 46) {
                isDouble = true;
            }
            if (state.getCurrentChar() == 45 && sb.length() > 0 && ((c2 = sb.charAt(sb.length() - 1)) != 'E' || c2 != 'e')) break;
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        if (Character.toUpperCase(state.getCurrentChar()) == 76) {
            isLong = true;
            state.nextChar();
        } else if (Character.toUpperCase(state.getCurrentChar()) == 70) {
            isFloat = true;
            isDouble = false;
            state.nextChar();
        } else if (Character.toUpperCase(state.getCurrentChar()) == 68) {
            isDouble = true;
            state.nextChar();
        }
        String numberStr = sb.toString();
        try {
            if (isDouble) {
                return Double.parseDouble(numberStr);
            }
            if (isFloat) {
                return Float.valueOf(Float.parseFloat(numberStr));
            }
            if (isLong) {
                return Long.parseLong(numberStr);
            }
            return Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            throw new CompilationException("Invalid number format: " + numberStr, e);
        }
    }

    private String parseIdentifier(ParserState state) {
        StringBuilder sb = new StringBuilder();
        while (state.isIdentifier()) {
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        return sb.toString();
    }

    private boolean eat(ParserState state, String expected) {
        state.skipWhitespace();
        for (int i = 0; i < expected.length(); ++i) {
            if (state.getCurrentChar() != expected.charAt(i)) {
                return false;
            }
            state.nextChar();
        }
        return true;
    }

    private boolean eat(ParserState state, char expected) {
        state.skipWhitespace();
        if (state.getCurrentChar() == expected) {
            state.nextChar();
            return true;
        }
        return false;
    }

    private void require(ParserState state, char expected, String errorMessage) {
        state.skipWhitespace();
        if (state.getCurrentChar() != expected) {
            throw new CompilationException(errorMessage);
        }
        state.nextChar();
    }

    private boolean checkKeyword(ParserState state, String keyword) {
        state.mark();
        for (int i = 0; i < keyword.length(); ++i) {
            if (state.getCurrentChar() != keyword.charAt(i)) {
                state.reset();
                return false;
            }
            state.nextChar();
        }
        if (state.isIdentifier()) {
            state.reset();
            return false;
        }
        return true;
    }

    private static class ParserState {
        private final String reader;
        private int ch;
        private int position = 0;
        private int markedCh = 0;
        private int markedPosition = 0;

        public ParserState(String reader) {
            this.reader = reader;
            this.nextChar();
        }

        public int getCurrentChar() {
            return this.ch;
        }

        public void nextChar() {
            if (this.position < this.reader.length()) {
                this.ch = this.reader.charAt(this.position);
                ++this.position;
            } else {
                this.ch = -1;
            }
        }

        public int peekNextChar() {
            if (this.position < this.reader.length()) {
                return this.reader.charAt(this.position);
            }
            return -1;
        }

        public void skipWhitespace() {
            while (Character.isWhitespace(this.ch)) {
                this.nextChar();
            }
        }

        public boolean isString() {
            return this.ch == 39 || this.ch == 34;
        }

        public boolean isNumber() {
            return Character.isDigit(this.ch) || this.ch == 45;
        }

        public boolean isDigit() {
            return Character.isDigit(this.ch);
        }

        public boolean isArray() {
            return this.ch == 91;
        }

        public boolean isIdentifier() {
            return Character.isLetterOrDigit(this.ch) || this.ch == 95;
        }

        public void mark() {
            this.markedCh = this.ch;
            this.markedPosition = this.position;
        }

        public void reset() {
            this.ch = this.markedCh;
            this.position = this.markedPosition;
        }

        public String toString() {
            return "ParserState{ch='" + (char)this.ch + "', position=" + this.position + '}';
        }
    }
}

