/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Parser;
import org.noear.solon.expression.snel.TemplateFragment;
import org.noear.solon.expression.snel.TemplateMarker;
import org.noear.solon.expression.snel.TemplateNode;
import org.noear.solon.expression.util.LRUCache;

public class SnelTemplateParser
implements Parser<String> {
    private static final SnelTemplateParser INSTANCE = new SnelTemplateParser(1000);
    private final Map<String, Expression<String>> exprCached;
    public static final char MARK_START_EXPRESSION = '#';
    public static final char MARK_START_PROPERTIES = '$';
    private static final char MARK_BRACE_OPEN = '{';
    private static final char MARK_BRACE_CLOSE = '}';

    public SnelTemplateParser(int cahceCapacity) {
        this.exprCached = Collections.synchronizedMap(new LRUCache(cahceCapacity));
    }

    public static SnelTemplateParser getInstance() {
        return INSTANCE;
    }

    @Override
    public Expression<String> parse(String expr, boolean cached) {
        return cached ? this.exprCached.computeIfAbsent(expr, this::parseDo) : this.parseDo(expr);
    }

    private Expression<String> parseDo(String expr) {
        ArrayList<TemplateFragment> fragments = new ArrayList<TemplateFragment>(expr.length() / 16);
        boolean inExpression = false;
        char marker = '\u0000';
        int textStart = 0;
        int scanPosition = 0;
        int length = expr.length();
        while (scanPosition < length) {
            if (!inExpression) {
                int exprStart = this.findExpressionStart(expr, scanPosition);
                if (exprStart != -1) {
                    if (textStart < exprStart) {
                        fragments.add(new TemplateFragment(TemplateMarker.TEXT, expr.substring(textStart, exprStart)));
                    }
                    marker = expr.charAt(exprStart);
                    inExpression = true;
                    textStart = scanPosition = exprStart + 2;
                    continue;
                }
                fragments.add(new TemplateFragment(TemplateMarker.TEXT, expr.substring(textStart)));
                break;
            }
            int closePos = this.findExpressionEnd(expr, scanPosition);
            if (closePos != -1) {
                String content = expr.substring(textStart, closePos);
                if ('$' == marker) {
                    fragments.add(new TemplateFragment(TemplateMarker.PROPERTIES, content));
                } else {
                    fragments.add(new TemplateFragment(TemplateMarker.EXPRESSION, content));
                }
                inExpression = false;
                textStart = scanPosition = closePos + 1;
                continue;
            }
            fragments.add(new TemplateFragment(TemplateMarker.TEXT, expr.substring(textStart - 2, textStart) + expr.substring(textStart)));
            break;
        }
        return new TemplateNode(fragments);
    }

    private int findExpressionStart(String s, int start) {
        for (int i = start; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (c != '#' && c != '$' || s.charAt(i + 1) != '{') continue;
            return i;
        }
        return -1;
    }

    private int findExpressionEnd(String s, int start) {
        int braceCount = 1;
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                ++braceCount;
                continue;
            }
            if (c != '}' || --braceCount != 0) continue;
            return i;
        }
        return -1;
    }
}

