/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.luffy.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.luffy.executor.IJtConfigAdapter;
import org.noear.luffy.executor.IJtExecutorAdapter;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.solon.luffy.impl.JtFunctionLoader;
import org.noear.solon.luffy.impl.JtFunctionLoaderDebug;
import org.noear.solon.luffy.impl.JtMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtExecutorAdapter
implements IJtExecutorAdapter,
IJtConfigAdapter {
    static Logger log = LoggerFactory.getLogger(JtExecutorAdapter.class);
    private String _defaultExecutor = JtMapping.getActuator("");
    private String _defLogTag = "luffy";
    private JtFunctionLoader forDebug = new JtFunctionLoaderDebug();
    private JtFunctionLoader forRelease;
    private String _nodeId;

    public JtExecutorAdapter(JtFunctionLoader resourceLoader) {
        this.forRelease = resourceLoader;
    }

    public void log(AFileModel file, Map<String, Object> data) {
        Context ctx;
        if (file == null && (ctx = Context.current()) != null) {
            file = (AFileModel)ctx.attr("file");
        }
        if (!data.containsKey("tag")) {
            TagsMDC.tag0((String)this._defLogTag);
        }
        if (file != null && !data.containsKey("tag2")) {
            TagsMDC.tag2((String)file.path);
        }
        log.debug("{}", data);
    }

    public void logError(AFileModel file, String msg, Throwable err) {
        TagsMDC.tag0((String)this._defLogTag);
        TagsMDC.tag2((String)file.path);
        if (err == null) {
            log.error("{}", (Object)msg);
        } else {
            log.error("{}\r\n{}", (Object)msg, (Object)err);
        }
    }

    public AFileModel fileGet(String path) throws Exception {
        AFileModel file = null;
        if (Solon.cfg().isDebugMode()) {
            file = this.forDebug.fileGet(path);
        }
        if (file == null || file.content == null) {
            file = this.forRelease.fileGet(path);
        }
        return file;
    }

    public List<AFileModel> fileFind(String tag, String label, boolean isCache) throws Exception {
        return Collections.emptyList();
    }

    public String nodeId() {
        if (this._nodeId == null) {
            this._nodeId = Utils.guid();
        }
        return this._nodeId;
    }

    public String defaultExecutor() {
        return this._defaultExecutor;
    }

    public void defaultExecutorSet(String defaultExecutor) {
        this._defaultExecutor = defaultExecutor;
    }

    public String cfgGet(String name, String def) throws Exception {
        if (Utils.isEmpty((String)name)) {
            return def;
        }
        return Solon.cfg().get(name, def);
    }

    public boolean cfgSet(String name, String value) throws Exception {
        if (Utils.isEmpty((String)name)) {
            return false;
        }
        Solon.cfg().setProperty(name, value);
        return true;
    }

    public Map cfgMap(String name) throws Exception {
        String val = Solon.cfg().get(name);
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        if (val != null) {
            tmp.put("value", val);
            tmp.put("name", name);
            tmp.put("tag", "luffy");
        }
        return tmp;
    }
}

