/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.luffy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.luffy.impl.JtFunctionLoader;
import org.noear.solon.luffy.impl.JtModelUtils;
import org.noear.solon.luffy.impl.JtRun;
import org.noear.solon.server.util.DebugUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtFunctionLoaderFile
implements JtFunctionLoader {
    static final Logger log = LoggerFactory.getLogger(JtFunctionLoaderFile.class);
    static final String debug_dir = "/luffy/";
    private final Map<String, AFileModel> fileCached = new LinkedHashMap<String, AFileModel>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private File _baseDir;
    private boolean _useCache = true;

    static JtFunctionLoaderFile ofDebug() {
        File dir = DebugUtils.getDebugLocation((ClassLoader)AppClassLoader.global(), (String)debug_dir);
        return new JtFunctionLoaderFile(dir, false);
    }

    public JtFunctionLoaderFile() {
        this("./luffy/");
    }

    public JtFunctionLoaderFile(String baseDir) {
        this._baseDir = new File(baseDir);
        if (!this._baseDir.exists()) {
            this._baseDir.mkdir();
        }
    }

    public JtFunctionLoaderFile(File baseDir, boolean useCache) {
        this._baseDir = baseDir;
        this._useCache = useCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AFileModel fileGet(String path) throws Exception {
        if (path.contains("../") || path.contains("..\\")) {
            return null;
        }
        File file = this.fileBuildDo(path);
        if (file == null) {
            return null;
        }
        if (!this._useCache) {
            return this.fileFillDo(new AFileModel(), file, path);
        }
        AFileModel fileModel = this.fileCached.get(path);
        if (fileModel == null) {
            this.SYNC_LOCK.lock();
            try {
                fileModel = this.fileCached.get(path);
                if (fileModel == null) {
                    fileModel = new AFileModel();
                    this.fileFillDo(fileModel, file, path);
                    this.fileCached.put(path, fileModel);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        if (fileModel.update_fulltime.getTime() != file.lastModified()) {
            this.SYNC_LOCK.lock();
            try {
                if (fileModel.update_fulltime.getTime() != file.lastModified()) {
                    this.fileFillDo(fileModel, file, path);
                }
                if (fileModel.content != null) {
                    JtRun.dele(path);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return fileModel;
    }

    protected AFileModel fileFillDo(AFileModel fileModel, File file, String path) throws Exception {
        fileModel.content = this.fileContentGet(file);
        if (fileModel.content != null) {
            if (fileModel.file_id == 0) {
                JtModelUtils.buildFileModel(fileModel, path);
            }
            fileModel.update_fulltime = new Date(file.lastModified());
        }
        return fileModel;
    }

    protected File fileBuildDo(String path) {
        if (this._baseDir == null) {
            return null;
        }
        File file = new File(this._baseDir, path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    protected String fileContentGet(File file) {
        String string;
        FileInputStream ins = new FileInputStream(file);
        try {
            string = IoUtil.transferToString((InputStream)ins, (String)Solon.encoding());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)ins).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        ((InputStream)ins).close();
        return string;
    }
}

