/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.flow.Container;
import org.noear.solon.flow.Evaluation;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.driver.SimpleFlowDriver;
import org.noear.solon.flow.stateful.FlowStateRepository;
import org.noear.solon.flow.stateful.NodeStates;
import org.noear.solon.flow.stateful.StatefulFlowContext;
import org.noear.solon.flow.stateful.StatefulNode;
import org.noear.solon.flow.stateful.repository.InMemoryStateRepository;

public class StatefulSimpleFlowDriver
extends SimpleFlowDriver {
    private final FlowStateRepository stateRepository;

    public FlowStateRepository getStateRepository() {
        return this.stateRepository;
    }

    public StatefulSimpleFlowDriver() {
        this(null);
    }

    public StatefulSimpleFlowDriver(FlowStateRepository stateRepository) {
        this.stateRepository = stateRepository == null ? new InMemoryStateRepository() : stateRepository;
    }

    public StatefulSimpleFlowDriver(FlowStateRepository stateRepository, Container container) {
        super(container);
        this.stateRepository = stateRepository == null ? new InMemoryStateRepository() : stateRepository;
    }

    public StatefulSimpleFlowDriver(FlowStateRepository stateRepository, Evaluation evaluation) {
        super(evaluation);
        this.stateRepository = stateRepository == null ? new InMemoryStateRepository() : stateRepository;
    }

    public StatefulSimpleFlowDriver(FlowStateRepository stateRepository, Evaluation evaluation, Container container) {
        super(evaluation, container);
        this.stateRepository = stateRepository == null ? new InMemoryStateRepository() : stateRepository;
    }

    public void handleTask(FlowContext context0, Task task) throws Throwable {
        StatefulFlowContext context;
        String instanceId;
        if (context0 instanceof StatefulFlowContext && Utils.isNotEmpty((String)(instanceId = (context = (StatefulFlowContext)context0).getInstanceId()))) {
            int nodeState = this.getStateRepository().getState(context, task.getNode().getChain().getId(), task.getNode().getId());
            if (nodeState == NodeStates.UNDEFINED) {
                if (this.isMyTask(context, task)) {
                    context.setTaskNode(new StatefulNode(task.getNode(), NodeStates.WAIT));
                    context.stop();
                    this.getStateRepository().postState(context, task.getNode().getChain().getId(), task.getNode().getId(), NodeStates.WAIT, context.engine());
                } else {
                    context.setTaskNode(new StatefulNode(task.getNode(), NodeStates.UNDEFINED));
                    context.interrupt();
                }
            } else if (nodeState == NodeStates.WAIT) {
                if (this.isMyTask(context, task)) {
                    context.setTaskNode(new StatefulNode(task.getNode(), nodeState));
                    context.stop();
                } else {
                    context.setTaskNode(new StatefulNode(task.getNode(), NodeStates.UNDEFINED));
                    context.interrupt();
                }
            }
            return;
        }
        super.handleTask(context0, task);
    }

    protected boolean isMyTask(StatefulFlowContext context, Task task) {
        String operator = (String)task.getNode().getMeta("operator");
        return Objects.equals(context.getOperator(), operator);
    }
}

