/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.FlowStateRecord;
import org.noear.solon.flow.stateful.FlowStateRepository;
import org.noear.solon.flow.stateful.NodeStates;
import org.noear.solon.flow.stateful.StatefulFlowContext;

public class InMemoryStateRepository
implements FlowStateRepository {
    private final Map<String, List<FlowStateRecord>> historyMap = new ConcurrentHashMap<String, List<FlowStateRecord>>();
    private final Map<String, Integer> stateMap = new ConcurrentHashMap<String, Integer>();

    @Override
    public int getState(StatefulFlowContext context, String chainId, String nodeId) {
        String stateKey = context.getInstanceId() + ":" + chainId + ":" + nodeId;
        Integer rst = this.stateMap.get(stateKey);
        if (rst == null) {
            return NodeStates.UNDEFINED;
        }
        return rst;
    }

    @Override
    public List<FlowStateRecord> getStateRecords(StatefulFlowContext context) {
        return Collections.unmodifiableList(this.historyMap.get(context.getInstanceId()));
    }

    @Override
    public void postState(StatefulFlowContext context, String chainId, String nodeId, int nodeState, FlowEngine flowEngine) {
        String instanceId = context.getInstanceId();
        List records = this.historyMap.computeIfAbsent(instanceId, k -> new ArrayList());
        records.add(new FlowStateRecord(chainId, nodeId, nodeState, context.getOperator(), System.currentTimeMillis()));
        if (nodeState == NodeStates.WITHDRAW) {
            Node node = flowEngine.getChain(chainId).getNode(nodeId);
            for (Node n1 : node.getPrveNodes()) {
                String stateKey = instanceId + ":" + chainId + ":" + n1.getId();
                this.stateMap.remove(stateKey);
            }
        } else if (nodeState == NodeStates.WITHDRAW_ALL) {
            this.stateMap.clear();
        } else {
            String stateKey = instanceId + ":" + chainId + ":" + nodeId;
            this.stateMap.put(stateKey, nodeState);
        }
    }
}

