/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngineDefault;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.stateful.NodeState;
import org.noear.solon.flow.stateful.StateRecord;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StatefulNode;
import org.noear.solon.flow.stateful.StatefulSimpleFlowDriver;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class StatefulFlowEngine
extends FlowEngineDefault {
    private StatefulSimpleFlowDriver driver;
    private ReentrantLock LOCKER = new ReentrantLock();

    public StatefulFlowEngine(StatefulSimpleFlowDriver driver) {
        this.driver = driver;
        this.register((FlowDriver)driver);
    }

    public StateRepository getRepository() {
        return this.driver.getStateRepository();
    }

    public StatefulNode stepForward(String chainId, FlowContext context) {
        return this.stepForward(this.getChain(chainId), context);
    }

    public StatefulNode stepForward(Chain chain, FlowContext context) {
        StatefulNode statefulNode = this.getActivityNode(chain, context);
        if (statefulNode != null) {
            this.postActivityState(context, statefulNode.getNode(), NodeState.PASS);
            statefulNode = new StatefulNode(statefulNode.getNode(), NodeState.PASS);
        }
        return statefulNode;
    }

    public StatefulNode stepBack(String chainId, FlowContext context) {
        return this.stepBack(this.getChain(chainId), context);
    }

    public StatefulNode stepBack(Chain chain, FlowContext context) {
        StatefulNode statefulNode = this.getActivityNode(chain, context);
        if (statefulNode != null) {
            this.postActivityState(context, statefulNode.getNode(), NodeState.BACK);
            statefulNode = new StatefulNode(statefulNode.getNode(), NodeState.BACK);
        }
        return statefulNode;
    }

    public StatefulNode getActivityNode(String chainId, FlowContext context) {
        return this.getActivityNode(this.getChain(chainId), context);
    }

    public StatefulNode getActivityNode(Chain chain, FlowContext context) {
        this.eval(chain, context);
        return (StatefulNode)context.get("activityNode");
    }

    public void postActivityState(FlowContext context, String chainId, String activityNodeId, int state) {
        Node node = this.getChain(chainId).getNode(activityNodeId);
        this.postActivityState(context, node, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postActivityState(FlowContext context, Node activity, int state) {
        this.LOCKER.lock();
        try {
            this.postActivityStateDo(context, activity, state);
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    protected void postActivityStateDo(FlowContext context, Node activity, int state) {
        int oldNodeState = this.driver.getStateRepository().getState(context, activity);
        if (oldNodeState == state) {
            return;
        }
        StateRecord stateRecord = this.driver.getStateOperator().createRecord(context, activity, state);
        this.driver.getStateRepository().addStateRecord(context, stateRecord);
        if (state == NodeState.BACK) {
            for (Node n1 : activity.getPrveNodes()) {
                this.driver.getStateRepository().removeState(context, n1);
            }
        } else if (state == NodeState.BACK_ALL) {
            this.driver.getStateRepository().clearState(context);
        } else {
            this.driver.getStateRepository().putState(context, activity, state);
        }
        if (state == NodeState.PASS) {
            try {
                this.postHandleTask(context, activity.getTask());
                Node nextNode = activity.getNextNode();
                if (nextNode != null && this.driver.getStateOperator().isAutoForward(context, nextNode)) {
                    this.eval(nextNode, context);
                }
            }
            catch (Throwable e) {
                throw new FlowException("Task handle failed: " + activity.getChain().getId() + " / " + activity.getId(), e);
            }
        }
    }

    protected void postHandleTask(FlowContext context, Task task) throws Throwable {
        this.driver.postHandleTask(context, task);
    }
}

