/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.NodeState;
import org.noear.solon.flow.stateful.StateRecord;
import org.noear.solon.flow.stateful.StateRepository;

public class InMemoryStateRepository<T extends StateRecord>
implements StateRepository<T> {
    private final Map<String, List<T>> historyMap = new ConcurrentHashMap<String, List<T>>();
    private final Map<String, Map<String, Integer>> stateMap = new ConcurrentHashMap<String, Map<String, Integer>>();

    private List<T> getHistory(String instanceId) {
        return this.historyMap.computeIfAbsent(instanceId, k -> new ArrayList());
    }

    public Map<String, Integer> getStates(String instanceId) {
        return this.stateMap.computeIfAbsent(instanceId, k -> new ConcurrentHashMap());
    }

    @Override
    public int getState(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        Integer rst = this.getStates(context.getInstanceId()).get(stateKey);
        if (rst == null) {
            return NodeState.UNDEFINED;
        }
        return rst;
    }

    @Override
    public void putState(FlowContext context, Node node, int nodeState) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.getStates(context.getInstanceId()).put(stateKey, nodeState);
    }

    @Override
    public void removeState(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.getStates(context.getInstanceId()).remove(stateKey);
    }

    @Override
    public void clearState(FlowContext context) {
        this.getStates(context.getInstanceId()).clear();
    }

    @Override
    public List<T> getStateRecords(FlowContext context) {
        return Collections.unmodifiableList(this.getHistory(context.getInstanceId()));
    }

    @Override
    public void addStateRecord(FlowContext context, T record) {
        this.getHistory(context.getInstanceId()).add(record);
    }

    @Override
    public void clearStateRecords(FlowContext context) {
        this.getHistory(context.getInstanceId()).clear();
    }
}

