/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import org.noear.solon.Utils;
import org.noear.solon.flow.Container;
import org.noear.solon.flow.Evaluation;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.driver.SimpleFlowDriver;
import org.noear.solon.flow.stateful.StateOperator;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StatefulFlowEngine;
import org.noear.solon.flow.stateful.StatefulNode;
import org.noear.solon.flow.stateful.operator.BlockStateOperator;
import org.noear.solon.flow.stateful.repository.InMemoryStateRepository;

public class StatefulSimpleFlowDriver
extends SimpleFlowDriver {
    private final StateRepository stateRepository;
    private final StateOperator stateOperator;

    public StateRepository getStateRepository() {
        return this.stateRepository;
    }

    public StateOperator getStateOperator() {
        return this.stateOperator;
    }

    public StatefulSimpleFlowDriver(StateRepository stateRepository, StateOperator stateOperator, Evaluation evaluation, Container container) {
        super(evaluation, container);
        this.stateRepository = stateRepository == null ? new InMemoryStateRepository() : stateRepository;
        this.stateOperator = stateOperator == null ? new BlockStateOperator() : stateOperator;
    }

    public void handleTask(FlowContext context, Task task) throws Throwable {
        String instanceId = context.getInstanceId();
        if (Utils.isNotEmpty((String)instanceId) && !this.stateOperator.isAutoForward(context, task.getNode())) {
            int nodeState = this.getStateRepository().getState(context, task.getNode());
            if (nodeState == 0) {
                if (this.stateOperator.isOperatable(context, task.getNode())) {
                    context.put("activityNode", (Object)new StatefulNode(task.getNode(), 1001));
                    context.stop();
                    ((StatefulFlowEngine)context.engine()).postActivityState(context, task.getNode(), 1001);
                } else {
                    context.put("activityNode", (Object)new StatefulNode(task.getNode(), 0));
                    context.interrupt();
                }
            } else if (nodeState == 1001) {
                if (this.stateOperator.isOperatable(context, task.getNode())) {
                    context.put("activityNode", (Object)new StatefulNode(task.getNode(), nodeState));
                    context.stop();
                } else {
                    context.put("activityNode", (Object)new StatefulNode(task.getNode(), 0));
                    context.interrupt();
                }
            }
            return;
        }
        this.postHandleTask(context, task);
    }

    protected void postHandleTask(FlowContext context, Task task) throws Throwable {
        super.handleTask(context, task);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private StateRepository stateRepository;
        private StateOperator stateOperator;
        private Evaluation evaluation;
        private Container container;

        public Builder stateRepository(StateRepository stateRepository) {
            this.stateRepository = stateRepository;
            return this;
        }

        public Builder stateOperator(StateOperator stateOperator) {
            this.stateOperator = stateOperator;
            return this;
        }

        public Builder evaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public Builder container(Container container) {
            this.container = container;
            return this;
        }

        public StatefulSimpleFlowDriver build() {
            return new StatefulSimpleFlowDriver(this.stateRepository, this.stateOperator, this.evaluation, this.container);
        }
    }
}

