/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.repository;

import java.util.ArrayList;
import java.util.List;
import org.noear.redisx.RedisClient;
import org.noear.snack.ONode;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.StateRecord;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.lang.Nullable;

public class RedisStateRepository<T extends StateRecord>
implements StateRepository<T> {
    private final RedisClient client;
    private final String statePrefix;
    private final String recordPrefix;

    public RedisStateRepository(RedisClient client) {
        this(client, "state:", "record:");
    }

    public RedisStateRepository(RedisClient client, String statePrefix, String recordPrefix) {
        this.client = client;
        this.statePrefix = statePrefix;
        this.recordPrefix = recordPrefix;
    }

    @Override
    public int getState(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        Integer rst = this.client.getHash(this.statePrefix + context.getInstanceId()).getAsInt(stateKey);
        if (rst == null) {
            return 0;
        }
        return rst;
    }

    @Override
    public void putState(FlowContext context, Node node, int nodeState) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.client.getHash(this.statePrefix + context.getInstanceId()).put(stateKey, nodeState);
    }

    @Override
    public void removeState(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.client.getHash(this.statePrefix + context.getInstanceId()).remove((Object)stateKey);
    }

    @Override
    public void clearState(FlowContext context) {
        this.client.getHash(this.statePrefix + context.getInstanceId()).clear();
    }

    @Override
    public List<T> getStateRecords(FlowContext context) {
        List list = this.client.getList(this.recordPrefix + context.getInstanceId()).getAll();
        ArrayList<Object> list1 = new ArrayList<Object>(list.size());
        for (String str : list) {
            list1.add(ONode.deserialize((String)str));
        }
        return list1;
    }

    @Override
    public void addStateRecord(FlowContext context, @Nullable T record) {
        if (record == null) {
            return;
        }
        this.client.getList(this.recordPrefix + context.getInstanceId()).add(ONode.serialize(record));
    }

    @Override
    public void clearStateRecords(FlowContext context) {
        this.client.getList(this.recordPrefix + context.getInstanceId()).clear();
    }
}

