/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.Node;

public class Link
implements Comparable<Link> {
    private final Chain chain;
    private final String prveId;
    private final LinkDecl decl;
    private Node prveNode;
    private Node nextNode;
    private Condition condition;

    public Link(Chain chain, String prveId, LinkDecl decl) {
        this.chain = chain;
        this.prveId = prveId;
        this.decl = decl;
    }

    public Chain chain() {
        return this.chain;
    }

    public Map<String, Object> meta() {
        return this.decl.meta;
    }

    public Condition condition() {
        if (this.condition == null) {
            this.condition = new Condition(this.decl.condition);
        }
        return this.condition;
    }

    public String prveId() {
        return this.prveId;
    }

    public String nextId() {
        return this.decl.nextId;
    }

    public Node prveNode() {
        if (this.prveNode == null) {
            this.prveNode = this.chain.getNode(this.prveId());
        }
        return this.prveNode;
    }

    public Node nextNode() {
        if (this.nextNode == null) {
            this.nextNode = this.chain.getNode(this.nextId());
        }
        return this.nextNode;
    }

    @Override
    public int compareTo(Link o) {
        if (this.decl.priority > o.decl.priority) {
            return -1;
        }
        if (this.decl.priority < o.decl.priority) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("priority=").append(this.decl.priority);
        buf.append(", prveId='").append(this.prveId()).append('\'');
        buf.append(", nextId='").append(this.nextId()).append('\'');
        if (Utils.isNotEmpty((String)this.decl.title)) {
            buf.append(", title='").append(this.decl.title).append('\'');
        }
        if (Utils.isNotEmpty(this.decl.meta)) {
            buf.append(", meta=").append(this.decl.meta);
        }
        if (Utils.isNotEmpty((String)this.decl.condition)) {
            buf.append(", condition=").append(this.decl.condition);
        }
        buf.append("}");
        return buf.toString();
    }
}

