/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.io.IOException;
import java.util.Collection;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.ChainContext;
import org.noear.solon.flow.ChainDriver;
import org.noear.solon.flow.FlowEngineImpl;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public interface FlowEngine {
    public static FlowEngine newInstance() {
        return new FlowEngineImpl();
    }

    public void register(String var1, ChainDriver var2);

    default public void register(ChainDriver driver) {
        this.register("", driver);
    }

    public void unregister(String var1);

    default public void load(String chainUri) throws IOException {
        if (chainUri.contains("*")) {
            for (String u1 : ResourceUtil.scanResources((String)chainUri)) {
                this.load(Chain.parseByUri(u1));
            }
        } else {
            this.load(Chain.parseByUri(chainUri));
        }
    }

    public void load(Chain var1);

    public void unload(String var1);

    public Collection<Chain> chains();

    default public void eval(String chainId) throws Throwable {
        this.eval(chainId, new ChainContext());
    }

    default public void eval(String chainId, ChainContext context) throws Throwable {
        this.eval(chainId, null, -1, context);
    }

    public void eval(String var1, String var2, int var3, ChainContext var4) throws Throwable;

    default public void eval(Chain chain) throws Throwable {
        this.eval(chain, new ChainContext());
    }

    default public void eval(Chain chain, ChainContext context) throws Throwable {
        this.eval(chain, null, -1, context);
    }

    public void eval(Chain var1, String var2, int var3, ChainContext var4) throws Throwable;
}

