/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.NodeType;

public class NodeDecl {
    protected final String id;
    protected String title;
    protected NodeType type;
    protected Map<String, Object> meta;
    protected List<LinkDecl> links = new ArrayList<LinkDecl>();
    protected String when;
    protected String task;

    public NodeDecl(String id, NodeType type) {
        this.id = id;
        this.type = type;
    }

    public NodeDecl title(String title) {
        this.title = title;
        return this;
    }

    public NodeDecl meta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public NodeDecl metaPut(String key, Object value) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, value);
        return this;
    }

    public NodeDecl linkAdd(String nextId, Consumer<LinkDecl> configure) {
        LinkDecl linkDecl = new LinkDecl(nextId);
        if (configure != null) {
            configure.accept(linkDecl);
        }
        this.links.add(linkDecl);
        return this;
    }

    public NodeDecl linkAdd(String nextId) {
        return this.linkAdd(nextId, null);
    }

    public NodeDecl when(String when) {
        this.when = when;
        return this;
    }

    public NodeDecl task(String task) {
        this.task = task;
        return this;
    }
}

