/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.NodeDecl;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.Task;

public class Node {
    private final transient Chain chain;
    private final NodeDecl decl;
    private final List<Link> nextLinks = new ArrayList<Link>();
    private List<Node> prveNodes;
    private List<Node> nextNodes;
    private List<Link> prveLinks;
    private Condition when;
    private Task task;

    protected Node(Chain chain, NodeDecl decl, List<Link> links) {
        this.chain = chain;
        this.decl = decl;
        if (links != null) {
            this.nextLinks.addAll(links);
            Collections.sort(this.nextLinks);
        }
    }

    public Chain chain() {
        return this.chain;
    }

    public String id() {
        return this.decl.id;
    }

    public String title() {
        return this.decl.title;
    }

    public NodeType type() {
        return this.decl.type;
    }

    public Map<String, Object> meta() {
        return Collections.unmodifiableMap(this.decl.meta);
    }

    public <T> T meta(String key) {
        return (T)this.decl.meta.get(key);
    }

    public <T> T metaOrDefault(String key, T def) {
        return (T)this.decl.meta.getOrDefault(key, def);
    }

    public List<Link> prveLinks() {
        if (this.prveLinks == null) {
            this.prveLinks = new ArrayList<Link>();
            if (this.type() != NodeType.start) {
                for (Link l : this.chain.links()) {
                    if (!this.id().equals(l.nextId())) continue;
                    this.prveLinks.add(l);
                }
                Collections.reverse(this.prveLinks);
            }
        }
        return this.prveLinks;
    }

    public List<Link> nextLinks() {
        return Collections.unmodifiableList(this.nextLinks);
    }

    public List<Node> prveNodes() {
        if (this.prveNodes == null) {
            this.prveNodes = new ArrayList<Node>();
            if (this.type() != NodeType.start) {
                for (Link l : this.chain.links()) {
                    if (!this.id().equals(l.nextId())) continue;
                    this.nextNodes.add(this.chain.getNode(l.prveId()));
                }
            }
        }
        return this.prveNodes;
    }

    public List<Node> nextNodes() {
        if (this.nextNodes == null) {
            this.nextNodes = new ArrayList<Node>();
            if (this.type() != NodeType.end) {
                for (Link l : this.nextLinks()) {
                    this.nextNodes.add(this.chain.getNode(l.nextId()));
                }
            }
        }
        return this.nextNodes;
    }

    public Node nextNode() {
        if (this.nextNodes().size() > 0) {
            return this.nextNodes().get(0);
        }
        return null;
    }

    public Condition when() {
        if (this.when == null) {
            this.when = new Condition(this.decl.when);
        }
        return this.when;
    }

    public Task task() {
        if (this.task == null) {
            this.task = new Task(this, this.decl.task);
        }
        return this.task;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("id='").append(this.decl.id).append('\'');
        buf.append(", type='").append((Object)this.decl.type).append('\'');
        if (Utils.isNotEmpty((String)this.decl.title)) {
            buf.append(", title='").append(this.decl.title).append('\'');
        }
        if (Utils.isNotEmpty((String)this.decl.when)) {
            buf.append(", when='").append(this.decl.when).append('\'');
        }
        if (Utils.isNotEmpty((String)this.decl.task)) {
            buf.append(", task='").append(this.decl.task).append('\'');
        }
        if (Utils.isNotEmpty(this.decl.links)) {
            buf.append(", link=").append(this.decl.links);
        }
        if (Utils.isNotEmpty(this.decl.meta)) {
            buf.append(", meta=").append(this.decl.meta);
        }
        buf.append("}");
        return buf.toString();
    }
}

