/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.solon.flow.Chain;

public class Counter {
    private final Map<String, AtomicInteger> counts = new LinkedHashMap<String, AtomicInteger>();
    private final Map<String, Stack<Integer>> stacks = new LinkedHashMap<String, Stack<Integer>>();

    protected Stack<Integer> stack(Chain chain, String key) {
        return this.stacks.computeIfAbsent(chain.id() + "/" + key, k -> new Stack());
    }

    protected int get(Chain chain, String key) {
        return this.counts.computeIfAbsent(chain.id() + "/" + key, k -> new AtomicInteger(0)).get();
    }

    protected void set(Chain chain, String key, int value) {
        this.counts.computeIfAbsent(chain.id() + "/" + key, k -> new AtomicInteger(0)).set(value);
    }

    protected int incr(Chain chain, String key) {
        return this.counts.computeIfAbsent(chain.id() + "/" + key, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public String toString() {
        return "{counts=" + this.counts + ", stacks=" + this.stacks + '}';
    }
}

