/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.ChainContext;
import org.noear.solon.flow.ChainDriver;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.driver.SolonChainDriver;
import org.noear.solon.flow.intercept.ChainInterceptor;
import org.noear.solon.flow.intercept.ChainInvocation;

class FlowEngineImpl
implements FlowEngine {
    protected final Map<String, Chain> chainMap = new ConcurrentHashMap<String, Chain>();
    protected final Map<String, ChainDriver> driverMap = new ConcurrentHashMap<String, ChainDriver>();
    protected final List<RankEntity<ChainInterceptor>> interceptorList = new ArrayList<RankEntity<ChainInterceptor>>();

    public FlowEngineImpl() {
        this.driverMap.put("", SolonChainDriver.getInstance());
    }

    @Override
    public void addInterceptor(ChainInterceptor interceptor, int index) {
        this.interceptorList.add((RankEntity<ChainInterceptor>)new RankEntity((Object)interceptor, index));
        Collections.sort(this.interceptorList);
    }

    @Override
    public void register(String name, ChainDriver driver) {
        if (driver != null) {
            this.driverMap.put(name, driver);
        }
    }

    @Override
    public void unregister(String name) {
        if (Utils.isNotEmpty((String)name)) {
            this.driverMap.remove(name);
        }
    }

    @Override
    public void load(Chain chain) {
        this.chainMap.put(chain.id(), chain);
    }

    @Override
    public void unload(String chainId) {
        this.chainMap.remove(chainId);
    }

    @Override
    public Collection<Chain> chains() {
        return this.chainMap.values();
    }

    @Override
    public void eval(String chainId, String startId, int depth, ChainContext context) throws Throwable {
        Chain chain = this.chainMap.get(chainId);
        if (chain == null) {
            throw new IllegalArgumentException("No chain found for id: " + chainId);
        }
        this.eval(chain, startId, depth, context);
    }

    @Override
    public void eval(Chain chain, String startId, int depth, ChainContext context) throws Throwable {
        ChainDriver driver;
        Node start = startId == null ? chain.start() : chain.getNode(startId);
        if (start == null) {
            throw new IllegalArgumentException("The start node was not found.");
        }
        if (context.engine == null) {
            context.engine = this;
        }
        if ((driver = this.driverMap.get(chain.driver())) == null) {
            throw new IllegalArgumentException("No driver found for: '" + chain.driver() + "'");
        }
        new ChainInvocation(driver, context, start, depth, this.interceptorList, (ConsumerEx<ChainInvocation>)((ConsumerEx)this::evalDo)).invoke();
    }

    protected void evalDo(ChainInvocation inv) throws Throwable {
        this.node_run(inv.getDriver(), inv.getContext(), inv.getStartNode(), inv.getEvalDepth());
    }

    private boolean condition_test(ChainDriver driver, ChainContext context, Condition condition, boolean def) throws Throwable {
        if (Utils.isNotEmpty((String)condition.description())) {
            return driver.handleTest(context, condition);
        }
        return def;
    }

    private void task_exec(ChainDriver driver, ChainContext context, Node node) throws Throwable {
        if (this.condition_test(driver, context, node.when(), true)) {
            driver.handleTask(context, node.task());
        }
    }

    private boolean node_run(ChainDriver driver, ChainContext context, Node node, int depth) throws Throwable {
        if (node == null) {
            return false;
        }
        if (context.isInterrupted()) {
            context.interrupt(false);
            return false;
        }
        if (context.isStopped()) {
            return false;
        }
        if (depth == 0) {
            return true;
        }
        --depth;
        driver.onNodeStart(context, node);
        if (context.isInterrupted()) {
            context.interrupt(false);
            return false;
        }
        if (context.isStopped()) {
            return false;
        }
        boolean node_end = true;
        switch (node.type()) {
            case start: {
                this.node_run(driver, context, node.nextNode(), depth);
                break;
            }
            case end: {
                break;
            }
            case execute: {
                this.task_exec(driver, context, node);
                this.node_run(driver, context, node.nextNode(), depth);
                break;
            }
            case inclusive: {
                node_end = this.inclusive_run(driver, context, node, depth);
                break;
            }
            case exclusive: {
                node_end = this.exclusive_run(driver, context, node, depth);
                break;
            }
            case parallel: {
                node_end = this.parallel_run(driver, context, node, depth);
            }
        }
        if (node_end) {
            driver.onNodeEnd(context, node);
        }
        return node_end;
    }

    private boolean inclusive_run(ChainDriver driver, ChainContext context, Node node, int depth) throws Throwable {
        Stack<Integer> inclusive_stack = context.counter().stack(node.chain(), "inclusive_run");
        if (node.prveLinks().size() > 1 && inclusive_stack.size() > 0) {
            int in_size;
            int start_size = inclusive_stack.peek();
            if (start_size > (in_size = context.counter().incr(node.chain(), node.id()))) {
                return false;
            }
            inclusive_stack.pop();
        }
        Link def_line = null;
        ArrayList<Link> matched_lines = new ArrayList<Link>();
        for (Link l : node.nextLinks()) {
            if (l.condition().isEmpty()) {
                def_line = l;
                continue;
            }
            if (!this.condition_test(driver, context, l.condition(), false)) continue;
            matched_lines.add(l);
        }
        if (matched_lines.size() > 0) {
            inclusive_stack.push(matched_lines.size());
            for (Link l : matched_lines) {
                this.node_run(driver, context, l.nextNode(), depth);
            }
        } else if (def_line != null) {
            this.node_run(driver, context, def_line.nextNode(), depth);
        }
        return true;
    }

    private boolean exclusive_run(ChainDriver driver, ChainContext context, Node node, int depth) throws Throwable {
        Link def_line = null;
        for (Link l : node.nextLinks()) {
            if (l.condition().isEmpty()) {
                def_line = l;
                continue;
            }
            if (!this.condition_test(driver, context, l.condition(), false)) continue;
            this.node_run(driver, context, l.nextNode(), depth);
            return true;
        }
        if (def_line != null) {
            this.node_run(driver, context, def_line.nextNode(), depth);
        }
        return true;
    }

    private boolean parallel_run(ChainDriver driver, ChainContext context, Node node, int depth) throws Throwable {
        int count = context.counter().incr(node.chain(), node.id());
        if (node.prveLinks().size() > count) {
            return false;
        }
        context.counter().set(node.chain(), node.id(), 0);
        for (Node n : node.nextNodes()) {
            this.node_run(driver, context, n, depth);
        }
        return true;
    }
}

