/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.driver;

import org.noear.liquor.eval.Exprs;
import org.noear.liquor.eval.Scripts;
import org.noear.solon.Utils;
import org.noear.solon.flow.ChainContext;
import org.noear.solon.flow.ChainDriver;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.TaskComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainDriver
implements ChainDriver {
    static final Logger log = LoggerFactory.getLogger(AbstractChainDriver.class);

    protected boolean isChain(String description) {
        return description.startsWith("#");
    }

    protected boolean isComponent(String description) {
        return description.startsWith("@");
    }

    @Override
    public void onNodeStart(ChainContext context, Node node) {
        log.debug("on-node-start: chain={}, node={}", (Object)node.chain().id(), (Object)node);
    }

    @Override
    public void onNodeEnd(ChainContext context, Node node) {
        log.debug("on-node-end: chain={}, node={}", (Object)node.chain().id(), (Object)node);
    }

    @Override
    public boolean handleTest(ChainContext context, Condition condition) throws Throwable {
        return this.handleConditionDo(context, condition, condition.description());
    }

    protected boolean handleConditionDo(ChainContext context, Condition condition, String description) throws Throwable {
        return this.tryAsScriptCondition(context, condition, description);
    }

    protected boolean tryAsScriptCondition(ChainContext context, Condition condition, String description) throws Throwable {
        return (Boolean)Exprs.eval((String)description, context.model());
    }

    @Override
    public void handleTask(ChainContext context, Task task) throws Throwable {
        if (Utils.isEmpty((String)task.description())) {
            return;
        }
        this.handleTaskDo(context, task, task.description());
    }

    protected void handleTaskDo(ChainContext context, Task task, String description) throws Throwable {
        if (this.isChain(description)) {
            this.tryAsChainTask(context, task, description);
            return;
        }
        if (this.isComponent(description)) {
            this.tryAsComponentTask(context, task, description);
            return;
        }
        this.tryAsScriptTask(context, task, description);
    }

    protected void tryAsChainTask(ChainContext context, Task task, String description) throws Throwable {
        String chainId = description.substring(1);
        context.engine().eval(chainId, context);
    }

    protected void tryAsComponentTask(ChainContext context, Task task, String description) throws Throwable {
        String beanName = description.substring(1);
        Object component = this.getComponent(beanName);
        if (component == null) {
            throw new IllegalStateException("The task component '" + beanName + "' not exist");
        }
        if (!(component instanceof TaskComponent)) {
            throw new IllegalStateException("The component '" + beanName + "' is not TaskComponent");
        }
        ((TaskComponent)component).run(context, task.node());
    }

    public abstract Object getComponent(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryAsScriptTask(ChainContext context, Task task, String description) throws Throwable {
        try {
            context.put("node", task.node());
            Scripts.eval((String)description, context.model());
        }
        finally {
            context.remove("node");
        }
    }
}

