/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.liquor.eval.Scripts;
import org.noear.solon.flow.Counter;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeType;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public class FlowContext {
    private final transient Map<String, Object> model = new LinkedHashMap<String, Object>();
    public transient Object result;
    private final transient Counter counter = new Counter();
    private transient boolean interrupted = false;
    private transient boolean stopped = false;
    protected transient FlowEngine engine;

    public FlowContext() {
        this(null);
    }

    public FlowContext(String instanceId) {
        this.put("context", this);
        this.put("instanceId", instanceId == null ? "" : instanceId);
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public FlowEngine engine() {
        return this.engine;
    }

    public Counter counter() {
        return this.counter;
    }

    public void manualNext(Node node) throws FlowException {
        this.manualNext(node, -1);
    }

    public void manualNext(Node node, int depth) throws FlowException {
        if (node.getType() != NodeType.ACTIVITY) {
            throw new IllegalArgumentException(node.getId() + " is not execute");
        }
        for (Node node1 : node.getNextNodes()) {
            this.engine.eval(node1, depth, this);
        }
    }

    public Object run(String script) throws InvocationTargetException {
        return Scripts.eval((String)script, this.model());
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    protected void interrupt(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public Map<String, Object> model() {
        return this.model;
    }

    public <Slf extends FlowContext> Slf put(String key, Object value) {
        if (value != null) {
            this.model.put(key, value);
        }
        return (Slf)this;
    }

    public <Slf extends FlowContext> Slf putIfAbsent(String key, Object value) {
        if (value != null) {
            this.model.putIfAbsent(key, value);
        }
        return (Slf)this;
    }

    public <Slf extends FlowContext> Slf putAll(Map<String, Object> model) {
        model.putAll(model);
        return (Slf)this;
    }

    public <T> T get(String key) {
        return (T)this.model.get(key);
    }

    public <T> T getOrDefault(String key, T def) {
        return (T)this.model.getOrDefault(key, def);
    }

    public void remove(String key) {
        this.model.remove(key);
    }

    public String getInstanceId() {
        return (String)this.get("instanceId");
    }
}

