/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.NodeType;

public class NodeDecl {
    protected final String id;
    protected String title;
    protected NodeType type;
    protected final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    protected List<LinkDecl> links = new ArrayList<LinkDecl>();
    protected String when;
    protected String task;

    public NodeDecl(String id, NodeType type) {
        this.id = id;
        this.type = type;
    }

    public NodeDecl title(String title) {
        this.title = title;
        return this;
    }

    public NodeDecl meta(Map<String, Object> map) {
        if (Utils.isNotEmpty(map)) {
            this.meta.putAll(map);
        }
        return this;
    }

    public NodeDecl metaPut(String key, Object value) {
        if (Utils.isNotEmpty((String)key)) {
            this.meta.put(key, value);
        }
        return this;
    }

    public NodeDecl linkAdd(String nextId, Consumer<LinkDecl> configure) {
        LinkDecl linkDecl = new LinkDecl(nextId);
        if (configure != null) {
            configure.accept(linkDecl);
        }
        this.links.add(linkDecl);
        return this;
    }

    public NodeDecl linkAdd(String nextId) {
        return this.linkAdd(nextId, null);
    }

    public NodeDecl when(String when) {
        this.when = when;
        return this;
    }

    public NodeDecl task(String task) {
        this.task = task;
        return this;
    }
}

