/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.driver;

import org.noear.solon.Utils;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.Container;
import org.noear.solon.flow.Evaluation;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.TaskComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowDriver
implements FlowDriver {
    static final Logger log = LoggerFactory.getLogger(AbstractFlowDriver.class);

    protected abstract Evaluation getEvaluation();

    protected abstract Container getContainer();

    protected boolean isChain(String description) {
        return description.startsWith("#");
    }

    protected boolean isComponent(String description) {
        return description.startsWith("@");
    }

    @Override
    public void onNodeStart(FlowContext context, Node node) {
    }

    @Override
    public void onNodeEnd(FlowContext context, Node node) {
    }

    @Override
    public boolean handleTest(FlowContext context, Condition condition) throws Throwable {
        return this.handleTestDo(context, condition, condition.getDescription());
    }

    protected boolean handleTestDo(FlowContext context, Condition condition, String description) throws Throwable {
        return this.tryAsScriptTest(context, condition, description);
    }

    protected boolean tryAsScriptTest(FlowContext context, Condition condition, String description) throws Throwable {
        return this.getEvaluation().runTest(context, description);
    }

    @Override
    public void handleTask(FlowContext context, Task task) throws Throwable {
        if (Utils.isEmpty((String)task.getDescription())) {
            return;
        }
        this.handleTaskDo(context, task, task.getDescription());
    }

    protected void handleTaskDo(FlowContext context, Task task, String description) throws Throwable {
        if (this.isChain(description)) {
            this.tryAsChainTask(context, task, description);
            return;
        }
        if (this.isComponent(description)) {
            this.tryAsComponentTask(context, task, description);
            return;
        }
        this.tryAsScriptTask(context, task, description);
    }

    protected void tryAsChainTask(FlowContext context, Task task, String description) throws Throwable {
        String chainId = description.substring(1);
        context.engine().eval(chainId, context);
    }

    protected void tryAsComponentTask(FlowContext context, Task task, String description) throws Throwable {
        String beanName = description.substring(1);
        Object component = this.getContainer().getComponent(beanName);
        if (component == null) {
            throw new IllegalStateException("The task component '" + beanName + "' not exist");
        }
        if (!(component instanceof TaskComponent)) {
            throw new IllegalStateException("The component '" + beanName + "' is not TaskComponent");
        }
        ((TaskComponent)component).run(context, task.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryAsScriptTask(FlowContext context, Task task, String description) throws Throwable {
        try {
            context.put("node", task.getNode());
            this.getEvaluation().runTask(context, description);
        }
        finally {
            context.remove("node");
        }
    }
}

