/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.integration;

import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.intercept.ChainInterceptor;

public class FlowPlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        FlowEngine flowEngine = FlowEngine.newInstance();
        List chainList = context.cfg().getList("solon.flow");
        if (Utils.isEmpty((Collection)chainList)) {
            flowEngine.load("classpath:flow/*.yml");
            flowEngine.load("classpath:flow/*.json");
        } else {
            for (String chainUri : chainList) {
                flowEngine.load(chainUri);
            }
        }
        context.wrapAndPut(FlowEngine.class, (Object)flowEngine);
        context.subWrapsOfType(FlowDriver.class, bw -> flowEngine.register(bw.name(), (FlowDriver)bw.raw()));
        context.subWrapsOfType(ChainInterceptor.class, bw -> flowEngine.addInterceptor((ChainInterceptor)bw.raw(), bw.index()));
    }
}

