/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowEngineDefault;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StateType;
import org.noear.solon.flow.stateful.StatefulFlowDriver;
import org.noear.solon.flow.stateful.StatefulFlowEngine;
import org.noear.solon.flow.stateful.StatefulNode;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class StatefulFlowEngineDefault
extends FlowEngineDefault
implements FlowEngine,
StatefulFlowEngine {
    private StatefulFlowDriver driver;
    private ReentrantLock LOCKER = new ReentrantLock();

    public StatefulFlowEngineDefault(StatefulFlowDriver driver) {
        this.driver = driver;
        this.register(driver);
    }

    public StateRepository getRepository() {
        return this.driver.getStateRepository();
    }

    @Override
    public void register(String name, FlowDriver driver) {
        if ("".equals(name)) {
            if (driver instanceof StatefulFlowDriver) {
                this.driver = (StatefulFlowDriver)driver;
            } else {
                throw new IllegalArgumentException("Default driver must be a StatefulFlowDriver");
            }
        }
        super.register(name, driver);
    }

    @Override
    public StatefulNode stepForward(String chainId, FlowContext context) {
        return this.stepForward(this.getChain(chainId), context);
    }

    @Override
    public StatefulNode stepForward(Chain chain, FlowContext context) {
        StatefulNode statefulNode = this.getActivityNode(chain, context);
        if (statefulNode != null) {
            this.postActivityState(context, statefulNode.getNode(), StateType.COMPLETED);
            statefulNode = new StatefulNode(statefulNode.getNode(), StateType.COMPLETED);
        }
        return statefulNode;
    }

    @Override
    public StatefulNode stepBack(String chainId, FlowContext context) {
        return this.stepBack(this.getChain(chainId), context);
    }

    @Override
    public StatefulNode stepBack(Chain chain, FlowContext context) {
        context.backup();
        StatefulNode statefulNode = this.getActivityNode(chain, context);
        if (statefulNode != null) {
            this.postActivityState(context, statefulNode.getNode(), StateType.RETURNED);
            context.recovery();
            statefulNode = this.getActivityNode(chain, context);
        }
        return statefulNode;
    }

    @Override
    public Collection<StatefulNode> getActivityNodes(String chainId, FlowContext context) {
        return this.getActivityNodes(this.getChain(chainId), context);
    }

    @Override
    public Collection<StatefulNode> getActivityNodes(Chain chain, FlowContext context) {
        context.put("ACTIVITY_LIST_GET", true);
        this.eval(chain, context);
        Collection tmp = (Collection)context.get("ACTIVITY_LIST");
        if (tmp == null) {
            return Collections.emptyList();
        }
        return tmp;
    }

    @Override
    public StatefulNode getActivityNode(String chainId, FlowContext context) {
        return this.getActivityNode(this.getChain(chainId), context);
    }

    @Override
    public StatefulNode getActivityNode(Chain chain, FlowContext context) {
        this.eval(chain, context);
        return (StatefulNode)context.get("ACTIVITY_NODE");
    }

    @Override
    public boolean postActivityStateIfWaiting(FlowContext context, String chainId, String activityNodeId, StateType state) {
        Node node = this.getChain(chainId).getNode(activityNodeId);
        return this.postActivityStateIfWaiting(context, node, state);
    }

    @Override
    public boolean postActivityStateIfWaiting(FlowContext context, Node activity, StateType state) {
        context.backup();
        StatefulNode statefulNode = this.getActivityNode(activity.getChain(), context);
        if (statefulNode == null) {
            return false;
        }
        if (statefulNode.getState() != StateType.WAITING) {
            return false;
        }
        if (!statefulNode.getNode().getId().equals(activity.getId())) {
            return false;
        }
        context.recovery();
        this.postActivityState(context, statefulNode.getNode(), state);
        return true;
    }

    @Override
    public void postActivityState(FlowContext context, String chainId, String activityNodeId, StateType state) {
        Node node = this.getChain(chainId).getNode(activityNodeId);
        this.postActivityState(context, node, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postActivityState(FlowContext context, Node activity, StateType state) {
        this.LOCKER.lock();
        try {
            this.postActivityStateDo(context, activity, state);
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    protected void postActivityStateDo(FlowContext context, Node activity, StateType state) {
        StateType oldState = this.driver.getStateRepository().getState(context, activity);
        if (oldState == state) {
            return;
        }
        if (state == StateType.RETURNED) {
            this.backHandle(activity, context);
        } else if (state == StateType.RESTART) {
            this.driver.getStateRepository().clearState(context);
        } else {
            this.driver.getStateRepository().putState(context, activity, state);
        }
        this.driver.getStateRepository().onPostActivityState(context, activity, state);
        if (state == StateType.COMPLETED) {
            try {
                this.driver.postHandleTask(context, activity.getTask());
                Node nextNode = activity.getNextNode();
                if (nextNode != null && this.driver.getStateController().isAutoForward(context, nextNode)) {
                    this.eval(nextNode, context);
                }
            }
            catch (Throwable e) {
                throw new FlowException("Task handle failed: " + activity.getChain().getId() + " / " + activity.getId(), e);
            }
        }
    }

    @Override
    public void clearActivityState(FlowContext context) {
        this.getRepository().clearState(context);
    }

    protected void backHandle(Node activity, FlowContext context) {
        for (Node n1 : activity.getPrevNodes()) {
            if (n1.getType() == NodeType.ACTIVITY) {
                this.driver.getStateRepository().removeState(context, n1);
                continue;
            }
            if (!NodeType.isGateway(n1.getType())) continue;
            for (Node n2 : n1.getNextNodes()) {
                if (n2.getType() != NodeType.ACTIVITY) continue;
                this.driver.getStateRepository().removeState(context, n2);
            }
            this.backHandle(n1, context);
        }
    }
}

