/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

public enum NodeType {
    START(0),
    END(1),
    ACTIVITY(11),
    INCLUSIVE(21),
    EXCLUSIVE(22),
    PARALLEL(23);

    private int code;

    public int getCode() {
        return this.code;
    }

    private NodeType(int code) {
        this.code = code;
    }

    public static NodeType codeOf(int code) {
        NodeType[] values;
        for (NodeType v : values = NodeType.values()) {
            if (v.code != code) continue;
            return v;
        }
        return ACTIVITY;
    }

    public static NodeType nameOf(String name) {
        NodeType[] values;
        for (NodeType v : values = NodeType.values()) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        return ACTIVITY;
    }

    public static boolean isGateway(NodeType nodeType) {
        return nodeType.getCode() > ACTIVITY.getCode();
    }
}

