/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.noear.dami.Dami;
import org.noear.dami.bus.DamiBus;
import org.noear.liquor.eval.Scripts;
import org.noear.solon.flow.Counter;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeType;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public class FlowContext {
    private final transient Map<String, Object> model = new ConcurrentHashMap<String, Object>();
    public transient Object result;
    private final transient Counter counter = new Counter();
    private transient boolean interrupted = false;
    private transient boolean stopped = false;
    protected transient FlowEngine engine;
    private FlowContext bak;

    public FlowContext() {
        this(null);
    }

    public FlowContext(String instanceId) {
        this.put("context", this);
        this.put("instanceId", instanceId == null ? "" : instanceId);
    }

    public void backup() {
        this.bak = new FlowContext();
        this.bak.putAll(this.model);
        this.bak.result = this.result;
        this.bak.interrupted = this.interrupted;
        this.bak.stopped = this.stopped;
        this.bak.counter.from(this.counter);
    }

    public void recovery() {
        if (this.bak != null) {
            this.model.clear();
            this.putAll(this.bak.model);
            this.put("context", this);
            this.result = this.bak.result;
            this.interrupted = this.bak.interrupted;
            this.stopped = this.bak.stopped;
            this.counter.from(this.bak.counter);
        }
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public FlowEngine engine() {
        return this.engine;
    }

    public Counter counter() {
        return this.counter;
    }

    public void manualNext(Node node) throws FlowException {
        this.manualNext(node, -1);
    }

    public void manualNext(Node node, int depth) throws FlowException {
        if (node.getType() != NodeType.ACTIVITY) {
            throw new IllegalArgumentException(node.getId() + " is not activity");
        }
        for (Node node1 : node.getNextNodes()) {
            this.engine.eval(node1, depth, this);
        }
    }

    public Object run(String script) throws InvocationTargetException {
        return Scripts.eval((String)script, this.model());
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void interrupt(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public Map<String, Object> model() {
        return this.model;
    }

    public <Slf extends FlowContext> Slf put(String key, Object value) {
        if (value != null) {
            this.model.put(key, value);
        }
        return (Slf)this;
    }

    public <Slf extends FlowContext> Slf putIfAbsent(String key, Object value) {
        if (value != null) {
            this.model.putIfAbsent(key, value);
        }
        return (Slf)this;
    }

    public <Slf extends FlowContext> Slf putAll(Map<String, Object> model) {
        this.model.putAll(model);
        return (Slf)this;
    }

    public <T> T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return (T)this.model.computeIfAbsent(key, mappingFunction);
    }

    public <T> T get(String key) {
        return (T)this.model.get(key);
    }

    public <T> T getOrDefault(String key, T def) {
        return (T)this.model.getOrDefault(key, def);
    }

    public void remove(String key) {
        this.model.remove(key);
    }

    public String getInstanceId() {
        return (String)this.get("instanceId");
    }

    public <C, R> DamiBus<C, R> eventBus() {
        return this.computeIfAbsent("eventBus", k -> Dami.newBus());
    }
}

