/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Collection;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngineDefault;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.intercept.ChainInterceptor;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public interface FlowEngine {
    public static FlowEngine newInstance() {
        return new FlowEngineDefault();
    }

    public void addInterceptor(ChainInterceptor var1, int var2);

    public void register(String var1, FlowDriver var2);

    default public void register(FlowDriver driver) {
        this.register("", driver);
    }

    public void unregister(String var1);

    default public void load(String chainUri) {
        if (chainUri.contains("*")) {
            for (String u1 : ResourceUtil.scanResources((String)chainUri)) {
                this.load(Chain.parseByUri(u1));
            }
        } else {
            this.load(Chain.parseByUri(chainUri));
        }
    }

    public void load(Chain var1);

    public void unload(String var1);

    public Collection<Chain> getChains();

    public Chain getChain(String var1);

    default public void eval(String chainId) throws FlowException {
        this.eval(chainId, new FlowContext());
    }

    default public void eval(String chainId, FlowContext context) throws FlowException {
        this.eval(chainId, null, -1, context);
    }

    default public void eval(String chainId, String startId, FlowContext context) throws FlowException {
        this.eval(chainId, startId, -1, context);
    }

    public void eval(String var1, String var2, int var3, FlowContext var4) throws FlowException;

    default public void eval(Chain chain) throws FlowException {
        this.eval(chain, new FlowContext());
    }

    default public void eval(Chain chain, FlowContext context) throws FlowException {
        this.eval(chain.getStart(), -1, context);
    }

    default public void eval(Node startNode) throws FlowException {
        this.eval(startNode, -1, new FlowContext());
    }

    default public void eval(Node startNode, FlowContext context) throws FlowException {
        this.eval(startNode, -1, context);
    }

    public void eval(Node var1, int var2, FlowContext var3) throws FlowException;
}

