/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeDecl;
import org.noear.solon.flow.NodeType;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public class Chain {
    private final String id;
    private final String title;
    private final String driver;
    private final Map<String, Object> meta = new HashMap<String, Object>();
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private final List<Link> links = new ArrayList<Link>();
    private Node start;

    public Chain(String id) {
        this(id, null, null);
    }

    public Chain(String id, String title) {
        this(id, title, null);
    }

    public Chain(String id, String title, String driver) {
        this.id = id;
        this.title = title == null ? id : title;
        this.driver = driver == null ? "" : driver;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDriver() {
        return this.driver;
    }

    public Map<String, Object> getMetas() {
        return this.meta;
    }

    public Object getMeta(String key) {
        return this.meta.get(key);
    }

    public Object getMetaOrDefault(String key, Object def) {
        return this.meta.getOrDefault(key, def);
    }

    public Node getStart() {
        return this.start;
    }

    public Map<String, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addNode(NodeDecl nodeDecl) {
        ArrayList<Link> linkAry = new ArrayList<Link>();
        for (LinkDecl linkSpec : nodeDecl.links) {
            linkAry.add(new Link(this, nodeDecl.id, linkSpec));
        }
        this.links.addAll(linkAry);
        Node node = new Node(this, nodeDecl, linkAry);
        this.nodes.put(node.getId(), node);
        if (nodeDecl.type == NodeType.START) {
            this.start = node;
        }
    }

    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    public void check() {
        if (this.start == null) {
            for (Node node : this.nodes.values()) {
                if (!Utils.isEmpty(node.getPrevLinks())) continue;
                this.start = node;
                break;
            }
        }
        if (this.start == null) {
            throw new IllegalStateException("No start node found, chain: " + this.id);
        }
    }

    public static Chain parseByUri(String uri) {
        URL url = ResourceUtil.findResource((String)uri, (boolean)false);
        if (url == null) {
            throw new IllegalArgumentException("Can't find resource: " + uri);
        }
        if (uri.endsWith(".json")) {
            try {
                return Chain.parseByDom(ONode.load((Object)ResourceUtil.getResourceAsString((URL)url)));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to load resource: " + url, ex);
            }
        }
        if (uri.endsWith(".yml") || uri.endsWith(".yaml") || uri.endsWith(".properties")) {
            return Chain.parseByProperties(Utils.loadProperties((URL)url));
        }
        throw new IllegalArgumentException("File format is not supported: " + uri);
    }

    public static Chain parseByText(String text) {
        return Chain.parseByProperties(Utils.buildProperties((String)text));
    }

    public static Chain parseByProperties(Properties properties) {
        return Chain.parseByDom(ONode.load((Object)properties));
    }

    public static Chain parseByDom(ONode dom) {
        String id = dom.get("id").getString();
        String title = dom.get("title").getString();
        String driver = dom.get("driver").getString();
        Chain chain = new Chain(id, title, driver);
        Map metaTmp = (Map)dom.get("meta").toObject(Map.class);
        if (Utils.isNotEmpty((Map)metaTmp)) {
            chain.getMetas().putAll(metaTmp);
        }
        List layoutTmp = null;
        layoutTmp = dom.contains("layout") ? dom.get("layout").ary() : dom.get("nodes").ary();
        NodeDecl nodesLat = null;
        for (int i = layoutTmp.size(); i > 0; --i) {
            ONode n1 = (ONode)layoutTmp.get(i - 1);
            String n1_id = n1.get("id").getString();
            if (Utils.isEmpty((String)n1_id)) {
                n1_id = "n-" + i;
            }
            String n1_typeStr = n1.get("type").getString();
            NodeType n1_type = NodeType.nameOf(n1_typeStr);
            NodeDecl nodeDecl = new NodeDecl(n1_id, n1_type);
            nodeDecl.title(n1.get("title").getString());
            nodeDecl.meta((Map)n1.get("meta").toObject(Map.class));
            nodeDecl.when(n1.get("when").getString());
            nodeDecl.task(n1.get("task").getString());
            ONode linkNode = n1.get("link");
            if (linkNode.isArray()) {
                for (ONode l1 : linkNode.ary()) {
                    if (l1.isObject()) {
                        Chain.addLink(nodeDecl, l1);
                        continue;
                    }
                    if (!l1.isValue()) continue;
                    nodeDecl.linkAdd(l1.getString());
                }
            } else if (linkNode.isObject()) {
                Chain.addLink(nodeDecl, linkNode);
            } else if (linkNode.isValue()) {
                nodeDecl.linkAdd(linkNode.getString());
            } else if (linkNode.isNull() && nodesLat != null) {
                nodeDecl.linkAdd(nodesLat.id);
            }
            nodesLat = nodeDecl;
            chain.addNode(nodeDecl);
        }
        chain.check();
        return chain;
    }

    private static void addLink(NodeDecl nodeDecl, ONode l1) {
        String conditionStr = l1.contains("when") ? l1.get("when").getString() : l1.get("condition").getString();
        nodeDecl.linkAdd(l1.get("nextId").getString(), ld -> ld.title(l1.get("title").getString()).meta((Map)l1.get("meta").toObject(Map.class)).condition(conditionStr));
    }

    public String toJson() {
        ONode oNode = new ONode();
        oNode.set("id", (Object)this.id);
        oNode.set("title", (Object)this.title);
        oNode.set("driver", (Object)this.driver);
        oNode.getOrNew("meta").fill(this.meta);
        oNode.getOrNew("layout").asArray().build(n1 -> {
            for (Map.Entry<String, Node> kv : this.nodes.entrySet()) {
                ONode n2 = n1.addNew();
                n2.set("id", (Object)kv.getKey());
                n2.set("title", (Object)kv.getValue().getTitle());
                n2.set("type", (Object)kv.getValue().getType().toString().toLowerCase());
                n2.getOrNew("meta").fill(kv.getValue().getMetas());
                if (kv.getValue().getWhen() != null) {
                    n2.set("when", (Object)kv.getValue().getWhen().getDescription());
                }
                if (kv.getValue().getTask() != null) {
                    n2.set("task", (Object)kv.getValue().getTask().getDescription());
                }
                if (!Utils.isNotEmpty(kv.getValue().getNextLinks())) continue;
                n2.getOrNew("link").asArray().build(n3 -> {
                    for (Link link : ((Node)kv.getValue()).getNextLinks()) {
                        ONode n4 = n3.addNew();
                        n4.set("nextId", (Object)link.getNextId());
                        n4.set("title", (Object)link.getTitle());
                        n4.getOrNew("meta").fill(link.getMetas());
                        if (link.getCondition() == null) continue;
                        n4.set("condition", (Object)link.getCondition().getDescription());
                    }
                });
            }
        });
        return oNode.toJson();
    }
}

