/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.controller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.stateful.StateController;

public class ActorStateController
implements StateController {
    private final Set<String> keys = new HashSet<String>();

    public ActorStateController() {
        this("actor");
    }

    public ActorStateController(String ... keys) {
        this.keys.addAll(Arrays.asList(keys));
    }

    @Override
    public boolean isOperatable(FlowContext context, Node node) {
        for (String key : this.keys) {
            String valOfCtx;
            String valOfMeta = (String)node.getMeta(key);
            if (!Objects.equals(valOfMeta, valOfCtx = (String)context.get(key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAutoForward(FlowContext context, Node node) {
        if (node.getType() == NodeType.END) {
            return true;
        }
        for (String key : this.keys) {
            if (!node.hasMeta(key)) continue;
            return false;
        }
        return true;
    }
}

