/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.noear.solon.Utils;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.driver.SimpleFlowDriver;
import org.noear.solon.flow.intercept.ChainInterceptor;
import org.noear.solon.flow.intercept.ChainInvocation;
import org.noear.solon.flow.stateful.FlowStatefulService;
import org.noear.solon.flow.stateful.FlowStatefulServiceDefault;

public class FlowEngineDefault
implements FlowEngine {
    protected final Map<String, Chain> chainMap = new ConcurrentHashMap<String, Chain>();
    protected final Map<String, FlowDriver> driverMap = new ConcurrentHashMap<String, FlowDriver>();
    protected final List<RankEntity<ChainInterceptor>> interceptorList = new ArrayList<RankEntity<ChainInterceptor>>();
    private FlowStatefulService statefulService;

    public FlowEngineDefault() {
        this(null);
    }

    public FlowEngineDefault(FlowDriver driver) {
        if (driver == null) {
            driver = new SimpleFlowDriver();
        }
        this.driverMap.put("", driver);
    }

    @Override
    public FlowDriver getDriver(Chain chain) {
        Assert.notNull((Object)chain, (String)"chain is null");
        FlowDriver driver = this.driverMap.get(chain.getDriver());
        if (driver == null) {
            throw new IllegalArgumentException("No driver found for: '" + chain.getDriver() + "'");
        }
        return driver;
    }

    @Override
    public <T extends FlowDriver> T getDriver(Chain chain, Class<T> driverClass) {
        FlowDriver driver = this.getDriver(chain);
        if (driverClass.isInstance(driver)) {
            return (T)driver;
        }
        throw new IllegalArgumentException("No " + driverClass.getSimpleName() + " found for: '" + chain.getDriver() + "'");
    }

    @Override
    public FlowStatefulService getStatefulService() {
        if (this.statefulService == null) {
            this.statefulService = new FlowStatefulServiceDefault(this);
        }
        return this.statefulService;
    }

    @Override
    public void addInterceptor(ChainInterceptor interceptor, int index) {
        this.interceptorList.add((RankEntity<ChainInterceptor>)new RankEntity((Object)interceptor, index));
        Collections.sort(this.interceptorList);
    }

    @Override
    public void register(String name, FlowDriver driver) {
        if (driver != null) {
            this.driverMap.put(name, driver);
        }
    }

    @Override
    public void unregister(String name) {
        if (Utils.isNotEmpty((String)name)) {
            this.driverMap.remove(name);
        }
    }

    @Override
    public void load(Chain chain) {
        this.chainMap.put(chain.getId(), chain);
    }

    @Override
    public void unload(String chainId) {
        this.chainMap.remove(chainId);
    }

    @Override
    public Collection<Chain> getChains() {
        return this.chainMap.values();
    }

    @Override
    public Chain getChain(String chainId) {
        return this.chainMap.get(chainId);
    }

    @Override
    public void eval(String chainId, String startId, int depth, FlowContext context) throws FlowException {
        Chain chain = this.chainMap.get(chainId);
        if (chain == null) {
            throw new IllegalArgumentException("No chain found for id: " + chainId);
        }
        Node startNode = startId == null ? chain.getStart() : chain.getNode(startId);
        this.eval(startNode, depth, context);
    }

    @Override
    public void eval(Node startNode, int depth, FlowContext context) throws FlowException {
        if (startNode == null) {
            throw new IllegalArgumentException("The start node was not found.");
        }
        this.initContextDo(context);
        FlowDriver driver = this.getDriver(startNode.getChain());
        new ChainInvocation(driver, context, startNode, depth, this.interceptorList, this::evalDo).invoke();
    }

    protected void initContextDo(FlowContext context) {
        if (context.engine == null) {
            context.engine = this;
        }
    }

    protected void evalDo(ChainInvocation inv) throws FlowException {
        this.node_run(inv.getDriver(), inv.getContext(), inv.getStartNode(), inv.getEvalDepth());
    }

    protected boolean condition_test(FlowDriver driver, FlowContext context, Condition condition, boolean def) throws FlowException {
        if (Utils.isNotEmpty((String)condition.getDescription())) {
            try {
                return driver.handleCondition(context, condition);
            }
            catch (FlowException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new FlowException("The test handle failed: " + condition.getChain().getId() + " / " + condition.getDescription(), e);
            }
        }
        return def;
    }

    protected void task_exec(FlowDriver driver, FlowContext context, Node node) throws FlowException {
        if (this.condition_test(driver, context, node.getWhen(), true)) {
            try {
                driver.handleTask(context, node.getTask());
            }
            catch (FlowException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new FlowException("The task handle failed: " + node.getChain().getId() + " / " + node.getId(), e);
            }
        }
    }

    protected boolean node_run(FlowDriver driver, FlowContext context, Node node, int depth) throws FlowException {
        if (node == null) {
            return false;
        }
        if (context.isStopped()) {
            return false;
        }
        if (context.isInterrupted()) {
            context.interrupt(false);
            return false;
        }
        if (depth == 0) {
            return true;
        }
        --depth;
        driver.onNodeStart(context, node);
        if (context.isStopped()) {
            return false;
        }
        if (context.isInterrupted()) {
            context.interrupt(false);
            return false;
        }
        boolean node_end = true;
        switch (node.getType()) {
            case START: {
                this.node_run(driver, context, node.getNextNode(), depth);
                break;
            }
            case END: {
                break;
            }
            case ACTIVITY: {
                this.task_exec(driver, context, node);
                this.exclusive_run(driver, context, node, depth);
                break;
            }
            case INCLUSIVE: {
                node_end = this.inclusive_run(driver, context, node, depth);
                break;
            }
            case EXCLUSIVE: {
                this.exclusive_run(driver, context, node, depth);
                break;
            }
            case PARALLEL: {
                node_end = this.parallel_run(driver, context, node, depth);
            }
        }
        if (node_end) {
            driver.onNodeEnd(context, node);
        }
        return node_end;
    }

    protected boolean inclusive_run(FlowDriver driver, FlowContext context, Node node, int depth) throws FlowException {
        Stack<Integer> inclusive_stack = context.counter().stack(node.getChain(), "inclusive_run");
        if (node.getPrevLinks().size() > 1 && inclusive_stack.size() > 0) {
            int in_size;
            int start_size = inclusive_stack.peek();
            if (start_size > (in_size = context.counter().incr(node.getChain(), node.getId()))) {
                return false;
            }
            inclusive_stack.pop();
        }
        Link def_line = null;
        ArrayList<Link> matched_lines = new ArrayList<Link>();
        for (Link l : node.getNextLinks()) {
            if (l.getWhen().isEmpty()) {
                def_line = l;
                continue;
            }
            if (!this.condition_test(driver, context, l.getWhen(), false)) continue;
            matched_lines.add(l);
        }
        if (matched_lines.size() > 0) {
            inclusive_stack.push(matched_lines.size());
            for (Link l : matched_lines) {
                this.node_run(driver, context, l.getNextNode(), depth);
            }
        } else if (def_line != null) {
            this.node_run(driver, context, def_line.getNextNode(), depth);
        }
        return true;
    }

    protected boolean exclusive_run(FlowDriver driver, FlowContext context, Node node, int depth) throws FlowException {
        Link def_line = null;
        for (Link l : node.getNextLinks()) {
            if (l.getWhen().isEmpty()) {
                def_line = l;
                continue;
            }
            if (!this.condition_test(driver, context, l.getWhen(), false)) continue;
            this.node_run(driver, context, l.getNextNode(), depth);
            return true;
        }
        if (def_line != null) {
            this.node_run(driver, context, def_line.getNextNode(), depth);
        }
        return true;
    }

    protected boolean parallel_run(FlowDriver driver, FlowContext context, Node node, int depth) throws FlowException {
        int count = context.counter().incr(node.getChain(), node.getId());
        if (node.getPrevLinks().size() > count) {
            return false;
        }
        context.counter().set(node.getChain(), node.getId(), 0);
        if (context.executor() == null || node.getNextNodes().size() < 2) {
            for (Node n : node.getNextNodes()) {
                this.node_run(driver, context, n, depth);
            }
        } else {
            CountDownLatch cdl = new CountDownLatch(node.getNextNodes().size());
            AtomicReference errorRef = new AtomicReference();
            for (Node n : node.getNextNodes()) {
                context.executor().execute(() -> {
                    try {
                        if (errorRef.get() != null) {
                            return;
                        }
                        this.node_run(driver, context, n, depth);
                    }
                    catch (Throwable ex) {
                        errorRef.set(ex);
                    }
                    finally {
                        cdl.countDown();
                    }
                });
            }
            try {
                cdl.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (errorRef.get() != null) {
                if (errorRef.get() instanceof FlowException) {
                    throw (FlowException)errorRef.get();
                }
                throw new FlowException((Throwable)errorRef.get());
            }
        }
        return true;
    }
}

