/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.stateful.FlowStatefulService;
import org.noear.solon.flow.stateful.Operation;
import org.noear.solon.flow.stateful.StateType;
import org.noear.solon.flow.stateful.StatefulFlowDriver;
import org.noear.solon.flow.stateful.StatefulTask;
import org.noear.solon.lang.Preview;

@Preview(value="3.4")
public class FlowStatefulServiceDefault
implements FlowStatefulService {
    private final FlowEngine flowEngine;
    private final ReentrantLock LOCKER = new ReentrantLock();

    public FlowStatefulServiceDefault(FlowEngine flowEngine) {
        this.flowEngine = flowEngine;
    }

    @Override
    public FlowEngine engine() {
        return this.flowEngine;
    }

    @Override
    public StatefulTask stepForward(String chainId, FlowContext context) {
        return this.stepForward(this.flowEngine.getChain(chainId), context);
    }

    @Override
    public StatefulTask stepForward(Chain chain, FlowContext context) {
        StatefulTask statefulTask = this.getTask(chain, context);
        if (statefulTask != null) {
            this.postOperation(context, statefulTask.getNode(), Operation.FORWARD);
            statefulTask = new StatefulTask(statefulTask.getNode(), StateType.COMPLETED);
        }
        return statefulTask;
    }

    @Override
    public StatefulTask stepBack(String chainId, FlowContext context) {
        return this.stepBack(this.flowEngine.getChain(chainId), context);
    }

    @Override
    public StatefulTask stepBack(Chain chain, FlowContext context) {
        context.backup();
        StatefulTask statefulTask = this.getTask(chain, context);
        if (statefulTask != null) {
            this.postOperation(context, statefulTask.getNode(), Operation.BACK);
            context.recovery();
            statefulTask = this.getTask(chain, context);
        }
        return statefulTask;
    }

    @Override
    public boolean postOperationIfWaiting(FlowContext context, String chainId, String nodeId, Operation operation) {
        Node node = this.flowEngine.getChain(chainId).getNode(nodeId);
        return this.postOperationIfWaiting(context, node, operation);
    }

    @Override
    public boolean postOperationIfWaiting(FlowContext context, Node node, Operation operation) {
        context.backup();
        StatefulTask statefulTask = this.getTask(node.getChain(), context);
        if (statefulTask == null) {
            return false;
        }
        if (statefulTask.getState() != StateType.WAITING) {
            return false;
        }
        if (!statefulTask.getNode().getId().equals(node.getId())) {
            return false;
        }
        context.recovery();
        this.postOperation(context, statefulTask.getNode(), operation);
        return true;
    }

    @Override
    public void postOperation(FlowContext context, String chainId, String nodeId, Operation operation) {
        Node node = this.flowEngine.getChain(chainId).getNode(nodeId);
        this.postOperation(context, node, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postOperation(FlowContext context, Node node, Operation operation) {
        this.LOCKER.lock();
        try {
            this.postOperationDo(context, node, operation);
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void postOperationDo(FlowContext context, Node node, Operation operation) {
        if (operation == Operation.UNKNOWN) {
            throw new IllegalArgumentException("StateOperation is UNKNOWN");
        }
        StateType newState = StateType.codeOf(operation.getCode());
        StatefulFlowDriver driver = this.flowEngine.getDriverAs(node.getChain(), StatefulFlowDriver.class);
        if (operation == Operation.BACK) {
            this.backHandle(driver, node, context);
            return;
        } else if (operation == Operation.RESTART) {
            driver.getStateRepository().clearState(context);
            return;
        } else if (operation == Operation.FORWARD) {
            try {
                driver.postHandleTask(context, node.getTask());
                driver.getStateRepository().putState(context, node, newState);
                Node nextNode = node.getNextNode();
                if (nextNode == null) return;
                if (nextNode.getType() == NodeType.INCLUSIVE || nextNode.getType() == NodeType.PARALLEL) {
                    StatefulTask statefulNextNode = this.getTask(node.getChain(), (FlowContext)new FlowContext().putAll(context.model()));
                    if (statefulNextNode == null) return;
                    nextNode = statefulNextNode.getNode();
                }
                if (nextNode == null) return;
                if (!driver.getStateController().isAutoForward(context, nextNode)) return;
                this.flowEngine.eval(nextNode, context);
                return;
            }
            catch (Throwable e) {
                throw new FlowException("Task handle failed: " + node.getChain().getId() + " / " + node.getId(), e);
            }
        } else {
            driver.getStateRepository().putState(context, node, newState);
        }
    }

    @Override
    public Collection<StatefulTask> getTasks(String chainId, FlowContext context) {
        return this.getTasks(this.flowEngine.getChain(chainId), context);
    }

    @Override
    public Collection<StatefulTask> getTasks(Chain chain, FlowContext context) {
        context.put("ACTIVITY_LIST_GET", true);
        this.flowEngine.eval(chain, context);
        Collection tmp = (Collection)context.get("ACTIVITY_LIST");
        if (tmp == null) {
            return Collections.emptyList();
        }
        return tmp;
    }

    @Override
    public StatefulTask getTask(String chainId, FlowContext context) {
        return this.getTask(this.flowEngine.getChain(chainId), context);
    }

    @Override
    public StatefulTask getTask(Chain chain, FlowContext context) {
        this.flowEngine.eval(chain, context);
        return (StatefulTask)context.get("ACTIVITY_NODE");
    }

    @Override
    public void clearState(String chainId, FlowContext context) {
        this.clearState(this.flowEngine.getChain(chainId), context);
    }

    @Override
    public void clearState(Chain chain, FlowContext context) {
        StatefulFlowDriver driver = this.flowEngine.getDriverAs(chain, StatefulFlowDriver.class);
        driver.getStateRepository().clearState(context);
    }

    protected void backHandle(StatefulFlowDriver driver, Node node, FlowContext context) {
        for (Node n1 : node.getPrevNodes()) {
            if (n1.getType() == NodeType.ACTIVITY) {
                driver.getStateRepository().removeState(context, n1);
                continue;
            }
            if (!NodeType.isGateway(n1.getType())) continue;
            for (Node n2 : n1.getNextNodes()) {
                if (n2.getType() != NodeType.ACTIVITY) continue;
                driver.getStateRepository().removeState(context, n2);
            }
            this.backHandle(driver, n1, context);
        }
    }
}

