/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.integration;

import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.core.AppContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.intercept.ChainInterceptor;

@Configuration
public class FlowConfigurate {
    @Condition(onMissingBean=FlowEngine.class)
    @Bean
    public FlowEngine flowEngine() {
        return FlowEngine.newInstance();
    }

    @Bean
    public void flowEngineInit(FlowEngine flowEngine, AppContext context) {
        List chainList = context.cfg().getList("solon.flow");
        if (Utils.isEmpty((Collection)chainList)) {
            flowEngine.load("classpath:flow/*.yml");
            flowEngine.load("classpath:flow/*.json");
        } else {
            for (String chainUri : chainList) {
                flowEngine.load(chainUri);
            }
        }
        context.subWrapsOfType(FlowDriver.class, bw -> flowEngine.register(bw.name(), (FlowDriver)bw.raw()));
        context.subWrapsOfType(ChainInterceptor.class, bw -> flowEngine.addInterceptor((ChainInterceptor)bw.raw(), bw.index()));
    }
}

