/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeDecl;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.Task;
import org.noear.solon.lang.Preview;
import org.yaml.snakeyaml.Yaml;

@Preview(value="3.0")
public class Chain {
    private final String id;
    private final String title;
    private final String driver;
    private final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    private final Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    private final List<Link> links = new ArrayList<Link>();
    private Node start;

    public Chain(String id) {
        this(id, null, null);
    }

    public Chain(String id, String title) {
        this(id, title, null);
    }

    public Chain(String id, String title, String driver) {
        this.id = id;
        this.title = title == null ? id : title;
        this.driver = driver == null ? "" : driver;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDriver() {
        return this.driver;
    }

    public Map<String, Object> getMetas() {
        return this.meta;
    }

    public Object getMeta(String key) {
        return this.meta.get(key);
    }

    public Object getMetaOrDefault(String key, Object def) {
        return this.meta.getOrDefault(key, def);
    }

    public Node getStart() {
        return this.start;
    }

    public Map<String, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addNode(NodeDecl nodeDecl) {
        ArrayList<Link> linkAry = new ArrayList<Link>();
        for (LinkDecl linkSpec : nodeDecl.links) {
            linkAry.add(new Link(this, nodeDecl.id, linkSpec));
        }
        this.links.addAll(linkAry);
        Node node = new Node(this, nodeDecl, linkAry);
        this.nodes.put(node.getId(), node);
        if (nodeDecl.type == NodeType.START) {
            this.start = node;
        }
    }

    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    public void check() {
        if (this.start == null) {
            for (Node node : this.nodes.values()) {
                if (!Utils.isEmpty(node.getPrevLinks())) continue;
                this.start = node;
                break;
            }
        }
        if (this.start == null) {
            throw new IllegalStateException("No start node found, chain: " + this.id);
        }
    }

    public static Chain parseByUri(String uri) {
        URL url = ResourceUtil.findResource((String)uri, (boolean)false);
        if (url == null) {
            throw new IllegalArgumentException("Can't find resource: " + uri);
        }
        if (uri.endsWith(".json") || uri.endsWith(".yml") || uri.endsWith(".yaml")) {
            try {
                return Chain.parseByText(ResourceUtil.getResourceAsString((URL)url));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to load resource: " + url, ex);
            }
        }
        throw new IllegalArgumentException("File format is not supported: " + uri);
    }

    public static Chain parseByText(String text) {
        Object dom = new Yaml().load(text);
        return Chain.parseByDom(ONode.load((Object)dom));
    }

    public static Chain parseByDom(ONode dom) {
        int i;
        String id = dom.get("id").getString();
        String title = dom.get("title").getString();
        String driver = dom.get("driver").getString();
        Chain chain = new Chain(id, title, driver);
        Map metaTmp = (Map)dom.get("meta").toObject(Map.class);
        if (Utils.isNotEmpty((Map)metaTmp)) {
            chain.getMetas().putAll(metaTmp);
        }
        List layoutTmp = null;
        layoutTmp = dom.contains("layout") ? dom.get("layout").ary() : dom.get("nodes").ary();
        ArrayList<NodeDecl> nodeDeclList = new ArrayList<NodeDecl>();
        NodeDecl nodesLat = null;
        for (i = layoutTmp.size(); i > 0; --i) {
            ONode n1 = (ONode)layoutTmp.get(i - 1);
            String n1_id = n1.get("id").getString();
            if (Utils.isEmpty((String)n1_id)) {
                n1_id = "n-" + i;
            }
            String n1_typeStr = n1.get("type").getString();
            NodeType n1_type = NodeType.nameOf(n1_typeStr);
            NodeDecl nodeDecl = new NodeDecl(n1_id, n1_type);
            nodeDecl.title(n1.get("title").getString());
            nodeDecl.meta((Map)n1.get("meta").toObject(Map.class));
            nodeDecl.when(n1.get("when").getString());
            nodeDecl.task(n1.get("task").getString());
            ONode linkNode = n1.get("link");
            if (linkNode.isArray()) {
                for (ONode l1 : linkNode.ary()) {
                    if (l1.isObject()) {
                        Chain.addLink(nodeDecl, l1);
                        continue;
                    }
                    if (!l1.isValue()) continue;
                    nodeDecl.linkAdd(l1.getString());
                }
            } else if (linkNode.isObject()) {
                Chain.addLink(nodeDecl, linkNode);
            } else if (linkNode.isValue()) {
                nodeDecl.linkAdd(linkNode.getString());
            } else if (linkNode.isNull() && nodesLat != null) {
                nodeDecl.linkAdd(nodesLat.id);
            }
            nodesLat = nodeDecl;
            nodeDeclList.add(nodeDecl);
        }
        for (i = nodeDeclList.size(); i > 0; --i) {
            chain.addNode((NodeDecl)nodeDeclList.get(i - 1));
        }
        chain.check();
        return chain;
    }

    private static void addLink(NodeDecl nodeDecl, ONode l1) {
        String whenStr = l1.contains("when") ? l1.get("when").getString() : l1.get("condition").getString();
        nodeDecl.linkAdd(l1.get("nextId").getString(), ld -> ld.title(l1.get("title").getString()).meta((Map)l1.get("meta").toObject(Map.class)).when(whenStr));
    }

    public String toYaml() {
        return new Yaml().dump(this.buildDom());
    }

    public String toJson() {
        return ONode.stringify(this.buildDom());
    }

    protected Map<String, Object> buildDom() {
        LinkedHashMap<String, Object> domRoot = new LinkedHashMap<String, Object>();
        domRoot.put("id", this.id);
        if (Utils.isNotEmpty((String)this.title)) {
            domRoot.put("title", this.title);
        }
        if (Utils.isNotEmpty((String)this.driver)) {
            domRoot.put("driver", this.driver);
        }
        if (Utils.isNotEmpty(this.meta)) {
            domRoot.put("meta", this.meta);
        }
        ArrayList domNodes = new ArrayList();
        domRoot.put("layout", domNodes);
        for (Map.Entry<String, Node> kv : this.nodes.entrySet()) {
            LinkedHashMap<String, Object> domNode = new LinkedHashMap<String, Object>();
            domNodes.add(domNode);
            domNode.put("id", kv.getKey());
            domNode.put("type", kv.getValue().getType().toString().toLowerCase());
            if (Utils.isNotEmpty((String)kv.getValue().getTitle())) {
                domNode.put("title", kv.getValue().getTitle());
            }
            if (Utils.isNotEmpty(kv.getValue().getMetas())) {
                domNode.put("meta", kv.getValue().getMetas());
            }
            if (Condition.isNotEmpty(kv.getValue().getWhen())) {
                domNode.put("when", kv.getValue().getWhen().getDescription());
            }
            if (Task.isNotEmpty(kv.getValue().getTask())) {
                domNode.put("task", kv.getValue().getTask().getDescription());
            }
            if (!Utils.isNotEmpty(kv.getValue().getNextLinks())) continue;
            ArrayList domLinks = new ArrayList();
            domNode.put("link", domLinks);
            for (Link link : kv.getValue().getNextLinks()) {
                LinkedHashMap<String, Object> domLink = new LinkedHashMap<String, Object>();
                domLinks.add(domLink);
                domLink.put("nextId", link.getNextId());
                if (Utils.isNotEmpty((String)link.getTitle())) {
                    domLink.put("title", link.getTitle());
                }
                if (Utils.isNotEmpty(link.getMetas())) {
                    domLink.put("meta", link.getMetas());
                }
                if (!Condition.isNotEmpty(link.getWhen())) continue;
                domLink.put("when", link.getWhen().getDescription());
            }
        }
        return domRoot;
    }
}

