/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

public enum NodeType {
    UNKNOWN(0),
    START(1),
    END(2),
    ACTIVITY(11),
    EXCLUSIVE(21),
    INCLUSIVE(22),
    PARALLEL(23);

    private int code;

    public int getCode() {
        return this.code;
    }

    private NodeType(int code) {
        this.code = code;
    }

    public static NodeType nameOf(String name) {
        return NodeType.nameOf(name, ACTIVITY);
    }

    public static NodeType nameOf(String name, NodeType defaultValue) {
        if (name != null) {
            NodeType[] values;
            for (NodeType v : values = NodeType.values()) {
                if (!v.name().equalsIgnoreCase(name)) continue;
                return v;
            }
        }
        return defaultValue;
    }

    public static boolean isGateway(NodeType nodeType) {
        return nodeType.getCode() > ACTIVITY.getCode();
    }
}

