/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.solon.flow.Chain;

public class Counter {
    static final String ROOT = "_ROOT";
    private final Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, Stack> stacks = new ConcurrentHashMap<String, Stack>();

    public void from(Counter counter) {
        this.counts.clear();
        this.stacks.clear();
        this.counts.putAll(counter.counts);
        this.stacks.putAll(counter.stacks);
    }

    public <T> Stack<T> stack(Chain chain, String key) {
        return this.stacks.computeIfAbsent(chain.getId() + "/" + key, k -> new Stack());
    }

    public int get(Chain chain, String key) {
        return this.counts.computeIfAbsent(chain.getId() + "/" + key, k -> new AtomicInteger(0)).get();
    }

    public int get(String key) {
        return this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).get();
    }

    public void set(Chain chain, String key, int value) {
        this.counts.computeIfAbsent(chain.getId() + "/" + key, k -> new AtomicInteger(0)).set(value);
    }

    public void set(String key, int value) {
        this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).set(value);
    }

    public int incr(Chain chain, String key) {
        return this.counts.computeIfAbsent(chain.getId() + "/" + key, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public int incr(String key) {
        return this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public int incr(String key, int delta) {
        return this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).addAndGet(delta);
    }

    public String toString() {
        return "{counts=" + this.counts + ", stacks=" + this.stacks + '}';
    }
}

