/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import org.noear.solon.core.util.Assert;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.StateType;
import org.noear.solon.lang.Preview;

public class StatefulTask {
    public static final String KEY_ACTIVITY_NODE = "ACTIVITY_NODE";
    public static final String KEY_ACTIVITY_LIST = "ACTIVITY_LIST";
    public static final String KEY_ACTIVITY_LIST_GET = "ACTIVITY_LIST_GET";
    private final FlowEngine flowEngine;
    private final Node node;
    private final StateType state;

    public StatefulTask(FlowEngine flowEngine, Node node, StateType state) {
        this.flowEngine = flowEngine;
        this.node = node;
        this.state = state;
    }

    @Preview(value="3.4")
    public void runTask(FlowContext context) throws FlowException {
        Assert.notNull((Object)this.node, (String)"node is null");
        try {
            this.flowEngine.getDriver(this.node.getChain()).handleTask(context, this.node.getTask());
        }
        catch (FlowException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FlowException("The task handle failed: " + this.node.getChain().getId() + " / " + this.node.getId(), e);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public StateType getState() {
        return this.state;
    }

    public String toString() {
        return "StatefulNode{node=" + this.node + ", state=" + (Object)((Object)this.state) + '}';
    }
}

