/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.driver;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.flow.Container;
import org.noear.solon.flow.Evaluation;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.driver.SimpleFlowDriver;
import org.noear.solon.flow.stateful.StateController;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StateType;
import org.noear.solon.flow.stateful.StatefulFlowDriver;
import org.noear.solon.flow.stateful.StatefulTask;
import org.noear.solon.flow.stateful.controller.BlockStateController;
import org.noear.solon.flow.stateful.repository.InMemoryStateRepository;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class StatefulSimpleFlowDriver
extends SimpleFlowDriver
implements FlowDriver,
StatefulFlowDriver {
    private final StateRepository stateRepository;
    private final StateController stateController;

    public StatefulSimpleFlowDriver(StateRepository stateRepository, StateController stateController, Evaluation evaluation, Container container) {
        super(evaluation, container);
        this.stateRepository = stateRepository == null ? new InMemoryStateRepository() : stateRepository;
        this.stateController = stateController == null ? new BlockStateController() : stateController;
    }

    @Override
    public StateRepository getStateRepository() {
        return this.stateRepository;
    }

    @Override
    public StateController getStateController() {
        return this.stateController;
    }

    @Override
    public void postHandleTask(FlowContext context, Task task) throws Throwable {
        super.handleTask(context, task);
    }

    @Override
    public void handleTask(FlowContext context, Task task) throws Throwable {
        String instanceId = context.getInstanceId();
        if (Utils.isNotEmpty((String)instanceId)) {
            if (this.stateController.isAutoForward(context, task.getNode())) {
                StateType state = this.getStateRepository().getState(context, task.getNode());
                if (state == StateType.UNKNOWN || state == StateType.WAITING) {
                    this.stateRepository.putState(context, task.getNode(), StateType.COMPLETED);
                    this.postHandleTask(context, task);
                } else if (state == StateType.TERMINATED) {
                    context.stop();
                }
            } else {
                StateType state = this.getStateRepository().getState(context, task.getNode());
                List nodeList = context.computeIfAbsent("ACTIVITY_LIST", k -> new ArrayList());
                boolean nodeListGet = context.getOrDefault("ACTIVITY_LIST_GET", false);
                if (state == StateType.UNKNOWN || state == StateType.WAITING) {
                    if (this.stateController.isOperatable(context, task.getNode())) {
                        StatefulTask statefulNode = new StatefulTask(context.engine(), task.getNode(), StateType.WAITING);
                        context.put("ACTIVITY_NODE", statefulNode);
                        nodeList.add(statefulNode);
                        if (nodeListGet) {
                            context.interrupt();
                        } else {
                            context.stop();
                        }
                    } else {
                        StatefulTask statefulNode = new StatefulTask(context.engine(), task.getNode(), StateType.UNKNOWN);
                        context.put("ACTIVITY_NODE", statefulNode);
                        nodeList.add(statefulNode);
                        context.interrupt();
                    }
                } else if (state == StateType.TERMINATED) {
                    StatefulTask statefulNode = new StatefulTask(context.engine(), task.getNode(), StateType.TERMINATED);
                    context.put("ACTIVITY_NODE", statefulNode);
                    nodeList.add(statefulNode);
                    if (nodeListGet) {
                        context.interrupt();
                    } else {
                        context.stop();
                    }
                }
            }
        } else {
            this.postHandleTask(context, task);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private StateRepository stateRepository;
        private StateController stateController;
        private Evaluation evaluation;
        private Container container;

        public Builder stateRepository(StateRepository stateRepository) {
            this.stateRepository = stateRepository;
            return this;
        }

        public Builder stateController(StateController stateController) {
            this.stateController = stateController;
            return this;
        }

        public Builder evaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public Builder container(Container container) {
            this.container = container;
            return this;
        }

        public StatefulSimpleFlowDriver build() {
            return new StatefulSimpleFlowDriver(this.stateRepository, this.stateController, this.evaluation, this.container);
        }
    }
}

