/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.noear.solon.Utils;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.FlowExchanger;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.driver.SimpleFlowDriver;
import org.noear.solon.flow.intercept.ChainInterceptor;
import org.noear.solon.flow.intercept.ChainInvocation;
import org.noear.solon.flow.stateful.FlowStatefulService;
import org.noear.solon.flow.stateful.FlowStatefulServiceDefault;

public class FlowEngineDefault
implements FlowEngine {
    protected final Map<String, Chain> chainMap = new ConcurrentHashMap<String, Chain>();
    protected final Map<String, FlowDriver> driverMap = new ConcurrentHashMap<String, FlowDriver>();
    protected final List<RankEntity<ChainInterceptor>> interceptorList = new ArrayList<RankEntity<ChainInterceptor>>();
    private FlowStatefulService statefulService;

    public FlowEngineDefault() {
        this(null);
    }

    public FlowEngineDefault(FlowDriver driver) {
        if (driver == null) {
            driver = new SimpleFlowDriver();
        }
        this.driverMap.put("", driver);
    }

    @Override
    public FlowDriver getDriver(Chain chain) {
        Assert.notNull((Object)chain, (String)"chain is null");
        FlowDriver driver = this.driverMap.get(chain.getDriver());
        if (driver == null) {
            throw new IllegalArgumentException("No driver found for: '" + chain.getDriver() + "'");
        }
        return driver;
    }

    @Override
    public <T extends FlowDriver> T getDriverAs(Chain chain, Class<T> driverClass) {
        FlowDriver driver = this.getDriver(chain);
        if (driverClass.isInstance(driver)) {
            return (T)driver;
        }
        throw new IllegalArgumentException("No " + driverClass.getSimpleName() + " found for: '" + chain.getDriver() + "'");
    }

    @Override
    public FlowStatefulService statefulService() {
        if (this.statefulService == null) {
            this.statefulService = new FlowStatefulServiceDefault(this);
        }
        return this.statefulService;
    }

    @Override
    public void addInterceptor(ChainInterceptor interceptor, int index) {
        this.interceptorList.add((RankEntity<ChainInterceptor>)new RankEntity((Object)interceptor, index));
        Collections.sort(this.interceptorList);
    }

    @Override
    public void removeInterceptor(ChainInterceptor interceptor) {
        for (RankEntity<ChainInterceptor> i : this.interceptorList) {
            if (i.target != interceptor) continue;
            this.interceptorList.remove(i);
            break;
        }
    }

    @Override
    public void register(String name, FlowDriver driver) {
        if (driver != null) {
            this.driverMap.put(name, driver);
        }
    }

    @Override
    public void unregister(String name) {
        if (Utils.isNotEmpty((String)name)) {
            this.driverMap.remove(name);
        }
    }

    @Override
    public void load(Chain chain) {
        this.chainMap.put(chain.getId(), chain);
    }

    @Override
    public void unload(String chainId) {
        this.chainMap.remove(chainId);
    }

    @Override
    public Collection<Chain> getChains() {
        return this.chainMap.values();
    }

    @Override
    public Chain getChain(String chainId) {
        return this.chainMap.get(chainId);
    }

    @Override
    public void eval(String chainId, String startId, int depth, FlowExchanger exchanger) throws FlowException {
        Chain chain = this.chainMap.get(chainId);
        if (chain == null) {
            throw new IllegalArgumentException("No chain found for id: " + chainId);
        }
        Node startNode = startId == null ? chain.getStart() : chain.getNode(startId);
        this.eval(startNode, depth, exchanger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eval(Node startNode, int depth, FlowExchanger exchanger) throws FlowException {
        if (startNode == null) {
            throw new IllegalArgumentException("The start node was not found.");
        }
        this.prepare(exchanger);
        FlowDriver driver = this.getDriver(startNode.getChain());
        FlowExchanger bak = (FlowExchanger)exchanger.context().getAs("exchanger");
        try {
            if (bak != exchanger) {
                exchanger.context().put("exchanger", exchanger);
            }
            new ChainInvocation(driver, exchanger, startNode, depth, this.interceptorList, this::evalDo).invoke();
        }
        finally {
            if (bak != exchanger) {
                if (bak == null) {
                    exchanger.context().remove("exchanger");
                } else {
                    exchanger.context().put("exchanger", bak);
                }
            }
        }
    }

    protected void prepare(FlowExchanger exchanger) {
        if (exchanger.engine == null) {
            exchanger.engine = this;
        }
    }

    protected void evalDo(ChainInvocation inv) throws FlowException {
        this.node_run(inv.getDriver(), inv.getExchanger(), inv.getStartNode(), inv.getEvalDepth());
    }

    protected void onNodeStart(FlowDriver driver, FlowExchanger exchanger, Node node) {
        for (RankEntity<ChainInterceptor> interceptor : this.interceptorList) {
            ((ChainInterceptor)interceptor.target).onNodeStart(exchanger.context(), node);
        }
        driver.onNodeStart(exchanger, node);
    }

    protected void onNodeEnd(FlowDriver driver, FlowExchanger exchanger, Node node) {
        for (RankEntity<ChainInterceptor> interceptor : this.interceptorList) {
            ((ChainInterceptor)interceptor.target).onNodeEnd(exchanger.context(), node);
        }
        driver.onNodeEnd(exchanger, node);
    }

    protected boolean condition_test(FlowDriver driver, FlowExchanger exchanger, Condition condition, boolean def) throws FlowException {
        if (Utils.isNotEmpty((String)condition.getDescription())) {
            try {
                return driver.handleCondition(exchanger, condition);
            }
            catch (FlowException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new FlowException("The test handle failed: " + condition.getChain().getId() + " / " + condition.getDescription(), e);
            }
        }
        return def;
    }

    protected void task_exec(FlowDriver driver, FlowExchanger exchanger, Node node) throws FlowException {
        if (this.condition_test(driver, exchanger, node.getWhen(), true)) {
            try {
                driver.handleTask(exchanger, node.getTask());
            }
            catch (FlowException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new FlowException("The task handle failed: " + node.getChain().getId() + " / " + node.getId(), e);
            }
        }
    }

    protected boolean node_run(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        if (node == null) {
            return false;
        }
        if (exchanger.isStopped()) {
            return false;
        }
        if (exchanger.isInterrupted()) {
            exchanger.interrupt(false);
            return false;
        }
        if (depth == 0) {
            return true;
        }
        --depth;
        this.onNodeStart(driver, exchanger, node);
        if (exchanger.isStopped()) {
            return false;
        }
        if (exchanger.isInterrupted()) {
            exchanger.interrupt(false);
            return false;
        }
        boolean node_end = true;
        switch (node.getType()) {
            case START: {
                this.node_run(driver, exchanger, node.getNextNode(), depth);
                break;
            }
            case END: {
                break;
            }
            case ACTIVITY: {
                node_end = this.activity_run(driver, exchanger, node, depth);
                break;
            }
            case INCLUSIVE: {
                node_end = this.inclusive_run(driver, exchanger, node, depth);
                break;
            }
            case EXCLUSIVE: {
                this.exclusive_run(driver, exchanger, node, depth);
                break;
            }
            case PARALLEL: {
                node_end = this.parallel_run(driver, exchanger, node, depth);
                break;
            }
            case ITERATOR: {
                node_end = this.iterator_run(driver, exchanger, node, depth);
            }
        }
        if (node_end) {
            this.onNodeEnd(driver, exchanger, node);
        }
        return node_end;
    }

    protected boolean activity_run(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) {
        if (node.getImode() == NodeType.PARALLEL ? !this.parallel_run_in(driver, exchanger, node, depth) : node.getImode() == NodeType.INCLUSIVE && !this.inclusive_run_in(driver, exchanger, node, depth)) {
            return false;
        }
        this.task_exec(driver, exchanger, node);
        if (exchanger.isStopped()) {
            return false;
        }
        if (exchanger.isInterrupted()) {
            exchanger.interrupt(false);
            return false;
        }
        if (node.getOmode() == NodeType.PARALLEL) {
            return this.parallel_run_out(driver, exchanger, node, depth);
        }
        if (node.getOmode() == NodeType.EXCLUSIVE) {
            return this.inclusive_run_out(driver, exchanger, node, depth);
        }
        return this.exclusive_run(driver, exchanger, node, depth);
    }

    protected boolean inclusive_run(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        if (this.inclusive_run_in(driver, exchanger, node, depth)) {
            return this.inclusive_run_out(driver, exchanger, node, depth);
        }
        return false;
    }

    protected boolean inclusive_run_in(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        Stack inclusive_stack = exchanger.temporary().stack(node.getChain(), "inclusive_run");
        if (node.getPrevLinks().size() > 1 && inclusive_stack.size() > 0) {
            int in_size;
            int start_size = (Integer)inclusive_stack.peek();
            if (start_size > (in_size = exchanger.temporary().countIncr(node.getChain(), node.getId()))) {
                return false;
            }
            inclusive_stack.pop();
        }
        return true;
    }

    protected boolean inclusive_run_out(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        Stack inclusive_stack = exchanger.temporary().stack(node.getChain(), "inclusive_run");
        Link def_line = null;
        ArrayList<Link> matched_lines = new ArrayList<Link>();
        for (Link l : node.getNextLinks()) {
            if (l.getWhen().isEmpty()) {
                def_line = l;
                continue;
            }
            if (!this.condition_test(driver, exchanger, l.getWhen(), false)) continue;
            matched_lines.add(l);
        }
        if (matched_lines.size() > 0) {
            inclusive_stack.push(matched_lines.size());
            for (Link l : matched_lines) {
                this.node_run(driver, exchanger, l.getNextNode(), depth);
            }
        } else if (def_line != null) {
            this.node_run(driver, exchanger, def_line.getNextNode(), depth);
        }
        return true;
    }

    protected boolean exclusive_run(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        Link def_line = null;
        for (Link l : node.getNextLinks()) {
            if (l.getWhen().isEmpty()) {
                def_line = l;
                continue;
            }
            if (!this.condition_test(driver, exchanger, l.getWhen(), false)) continue;
            this.node_run(driver, exchanger, l.getNextNode(), depth);
            return true;
        }
        if (def_line != null) {
            this.node_run(driver, exchanger, def_line.getNextNode(), depth);
        }
        return true;
    }

    protected boolean parallel_run(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        if (this.parallel_run_in(driver, exchanger, node, depth)) {
            return this.parallel_run_out(driver, exchanger, node, depth);
        }
        return false;
    }

    protected boolean parallel_run_in(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        int count = exchanger.temporary().countIncr(node.getChain(), node.getId());
        return node.getPrevLinks().size() <= count;
    }

    protected boolean parallel_run_out(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) throws FlowException {
        exchanger.temporary().countSet(node.getChain(), node.getId(), 0);
        if (exchanger.context().executor() == null || node.getNextNodes().size() < 2) {
            for (Node n : node.getNextNodes()) {
                this.node_run(driver, exchanger, n, depth);
            }
        } else {
            CountDownLatch cdl = new CountDownLatch(node.getNextNodes().size());
            AtomicReference errorRef = new AtomicReference();
            for (Node n : node.getNextNodes()) {
                exchanger.context().executor().execute(() -> {
                    try {
                        if (errorRef.get() != null) {
                            return;
                        }
                        this.node_run(driver, exchanger, n, depth);
                    }
                    catch (Throwable ex) {
                        errorRef.set(ex);
                    }
                    finally {
                        cdl.countDown();
                    }
                });
            }
            try {
                cdl.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (errorRef.get() != null) {
                if (errorRef.get() instanceof FlowException) {
                    throw (FlowException)errorRef.get();
                }
                throw new FlowException((Throwable)errorRef.get());
            }
        }
        return true;
    }

    protected boolean iterator_run(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) {
        if (node.getMeta("$for") == null) {
            if (this.iterator_run_in(driver, exchanger, node, depth)) {
                return this.node_run(driver, exchanger, node.getNextNode(), depth);
            }
            return false;
        }
        return this.iterator_run_out(driver, exchanger, node, depth);
    }

    protected boolean iterator_run_in(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) {
        Stack iterator_stack = exchanger.temporary().stack(node.getChain(), "iterator_run");
        if (iterator_stack.size() > 0) {
            Iterator inIterator = (Iterator)iterator_stack.peek();
            if (inIterator.hasNext()) {
                return false;
            }
            iterator_stack.pop();
        }
        return true;
    }

    protected boolean iterator_run_out(FlowDriver driver, FlowExchanger exchanger, Node node, int depth) {
        String forKey = (String)node.getMeta("$for");
        String inKey = (String)node.getMeta("$in");
        Object inObj = exchanger.context().getAs(inKey);
        Iterator inIterator = null;
        if (inObj instanceof Iterator) {
            inIterator = (Iterator)inObj;
        } else if (inObj instanceof Iterable) {
            inIterator = ((Iterable)inObj).iterator();
        } else {
            throw new FlowException(inKey + " is not a Iterable");
        }
        Stack iterator_stack = exchanger.temporary().stack(node.getChain(), "iterator_run");
        iterator_stack.push(inIterator);
        while (inIterator.hasNext()) {
            Object item = inIterator.next();
            exchanger.context().put(forKey, item);
            this.node_run(driver, exchanger, node.getNextNode(), depth);
        }
        return true;
    }
}

