/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.driver;

import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.Container;
import org.noear.solon.flow.Evaluation;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.FlowExchanger;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.TaskComponent;
import org.noear.solon.flow.container.SolonContainer;
import org.noear.solon.flow.evaluation.LiquorEvaluation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowDriver
implements FlowDriver {
    static final Logger log = LoggerFactory.getLogger(AbstractFlowDriver.class);
    private final Evaluation evaluation;
    private final Container container;

    public AbstractFlowDriver(Evaluation evaluation, Container container) {
        this.evaluation = evaluation == null ? new LiquorEvaluation() : evaluation;
        this.container = container == null ? new SolonContainer() : container;
    }

    protected Evaluation getEvaluation() {
        return this.evaluation;
    }

    protected Container getContainer() {
        return this.container;
    }

    protected boolean isChain(String description) {
        return description.startsWith("#");
    }

    protected boolean isComponent(String description) {
        return description.startsWith("@");
    }

    @Override
    public void onNodeStart(FlowExchanger exchanger, Node node) {
    }

    @Override
    public void onNodeEnd(FlowExchanger exchanger, Node node) {
    }

    @Override
    public boolean handleCondition(FlowExchanger exchanger, Condition condition) throws Throwable {
        return this.handleConditionDo(exchanger, condition, condition.getDescription());
    }

    protected boolean handleConditionDo(FlowExchanger exchanger, Condition condition, String description) throws Throwable {
        return this.tryAsScriptCondition(exchanger, condition, description);
    }

    protected boolean tryAsScriptCondition(FlowExchanger exchanger, Condition condition, String description) throws Throwable {
        return this.getEvaluation().runTest(exchanger.context(), description);
    }

    @Override
    public void postHandleTask(FlowExchanger exchanger, Task task) throws Throwable {
        if (Utils.isEmpty((String)task.getDescription())) {
            return;
        }
        this.handleTaskDo(exchanger, task, task.getDescription());
    }

    protected void handleTaskDo(FlowExchanger exchanger, Task task, String description) throws Throwable {
        if (this.isChain(description)) {
            this.tryAsChainTask(exchanger, task, description);
            return;
        }
        if (this.isComponent(description)) {
            this.tryAsComponentTask(exchanger, task, description);
            return;
        }
        this.tryAsScriptTask(exchanger, task, description);
    }

    protected void tryAsChainTask(FlowExchanger exchanger, Task task, String description) throws Throwable {
        String chainId = description.substring(1);
        exchanger.engine().eval(chainId, null, -1, exchanger);
    }

    protected void tryAsComponentTask(FlowExchanger exchanger, Task task, String description) throws Throwable {
        String beanName = description.substring(1);
        Object component = this.getContainer().getComponent(beanName);
        if (component == null) {
            throw new IllegalStateException("The task component '" + beanName + "' not exist");
        }
        if (!(component instanceof TaskComponent)) {
            throw new IllegalStateException("The component '" + beanName + "' is not TaskComponent");
        }
        ((TaskComponent)component).run(exchanger.context(), task.getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryAsScriptTask(FlowExchanger exchanger, Task task, String description) throws Throwable {
        if (description.startsWith("$")) {
            String metaName = description.substring(1);
            description = (String)this.getDepthMeta(task.getNode().getChain().getMetas(), metaName);
            if (Utils.isEmpty((String)description)) {
                throw new FlowException("Chain meta not found: " + metaName);
            }
        }
        try {
            exchanger.context().put("node", task.getNode());
            this.getEvaluation().runTask(exchanger.context(), description);
        }
        finally {
            exchanger.context().remove("node");
        }
    }

    protected Object getDepthMeta(Map metas, String key) {
        String[] fragments = key.split("\\.");
        Object rst = null;
        int len = fragments.length;
        for (int i = 0; i < len; ++i) {
            String key1 = fragments[i];
            rst = i == 0 ? metas.get(key1) : ((Map)rst).get(key1);
            if (rst == null) break;
        }
        return rst;
    }
}

