/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.repository;

import org.noear.redisx.RedisClient;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StateType;

public class RedisStateRepository
implements StateRepository {
    private final RedisClient client;
    private final String statePrefix;

    public RedisStateRepository(RedisClient client) {
        this(client, "flow:state:");
    }

    public RedisStateRepository(RedisClient client, String statePrefix) {
        this.client = client;
        this.statePrefix = statePrefix;
    }

    @Override
    public StateType stateGet(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        Integer code = this.client.getHash(this.statePrefix + context.getInstanceId()).getAsInt(stateKey);
        if (code == null) {
            return StateType.UNKNOWN;
        }
        return StateType.codeOf(code);
    }

    @Override
    public void statePut(FlowContext context, Node node, StateType state) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.client.getHash(this.statePrefix + context.getInstanceId()).put(stateKey, state.getCode());
    }

    @Override
    public void stateRemove(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.client.getHash(this.statePrefix + context.getInstanceId()).remove((Object)stateKey);
    }

    @Override
    public void stateClear(FlowContext context) {
        this.client.getHash(this.statePrefix + context.getInstanceId()).clear();
    }
}

