/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful.repository;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StateType;

public class InMemoryStateRepository
implements StateRepository {
    private final Map<String, Map<String, Integer>> stateMap = new ConcurrentHashMap<String, Map<String, Integer>>();

    public Map<String, Integer> getStates(String instanceId) {
        return this.stateMap.computeIfAbsent(instanceId, k -> new ConcurrentHashMap());
    }

    @Override
    public StateType stateGet(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        Integer code = this.getStates(context.getInstanceId()).get(stateKey);
        if (code == null) {
            return StateType.UNKNOWN;
        }
        return StateType.codeOf(code);
    }

    @Override
    public void statePut(FlowContext context, Node node, StateType state) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.getStates(context.getInstanceId()).put(stateKey, state.getCode());
    }

    @Override
    public void stateRemove(FlowContext context, Node node) {
        String stateKey = node.getChain().getId() + ":" + node.getId();
        this.getStates(context.getInstanceId()).remove(stateKey);
    }

    @Override
    public void stateClear(FlowContext context) {
        this.getStates(context.getInstanceId()).clear();
    }
}

