/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.stateful;

import org.noear.solon.flow.AbstractFlowContext;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.stateful.StateController;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StateType;
import org.noear.solon.flow.stateful.StatefulSupporter;

public class StatefulFlowContext
extends AbstractFlowContext
implements StatefulSupporter {
    private final transient StateController stateController;
    private final transient StateRepository stateRepository;

    public StatefulFlowContext(String instanceId, StateController stateController, StateRepository stateRepository) {
        super(instanceId);
        this.stateController = stateController;
        this.stateRepository = stateRepository;
    }

    @Override
    public final boolean isStateful() {
        return true;
    }

    @Override
    public StatefulSupporter statefulSupporter() {
        return this;
    }

    @Override
    public boolean isOperatable(Node node) {
        return this.stateController.isOperatable(this, node);
    }

    @Override
    public boolean isAutoForward(Node node) {
        return this.stateController.isAutoForward(this, node);
    }

    @Override
    public StateType stateGet(Node node) {
        return this.stateRepository.stateGet(this, node);
    }

    @Override
    public void statePut(Node node, StateType state) {
        this.stateRepository.statePut(this, node, state);
    }

    @Override
    public void stateRemove(Node node) {
        this.stateRepository.stateRemove(this, node);
    }

    @Override
    public void stateClear() {
        this.stateRepository.stateClear(this);
    }
}

