/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.noear.dami2.Dami;
import org.noear.dami2.bus.DamiBus;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.lang.Nullable;
import org.noear.solon.lang.Preview;

@Preview(value="3.5")
public abstract class AbstractFlowContext
implements FlowContext {
    private final transient Map<String, Object> model = new ConcurrentHashMap<String, Object>();
    private transient ExecutorService executor;

    public AbstractFlowContext() {
        this(null);
    }

    public AbstractFlowContext(String instanceId) {
        this.put("instanceId", instanceId == null ? "" : instanceId);
        this.put("context", this);
    }

    @Override
    @Preview(value="3.3")
    @Nullable
    public ExecutorService executor() {
        return this.executor;
    }

    @Override
    @Preview(value="3.3")
    public AbstractFlowContext executor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public Map<String, Object> model() {
        return this.model;
    }

    @Override
    public AbstractFlowContext put(String key, Object value) {
        if (value != null) {
            this.model.put(key, value);
        }
        return this;
    }

    @Override
    public AbstractFlowContext putIfAbsent(String key, Object value) {
        if (value != null) {
            this.model.putIfAbsent(key, value);
        }
        return this;
    }

    @Override
    public AbstractFlowContext putAll(Map<String, Object> model) {
        this.model.putAll(model);
        return this;
    }

    @Override
    public <T> T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return (T)this.model.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public <T> T getAs(String key) {
        return (T)this.model.get(key);
    }

    public Object getAsObject(String key) {
        return this.getAs(key);
    }

    public String getAsString(String key) {
        return (String)this.getAs(key);
    }

    public Number getAsNumber(String key) {
        return (Number)this.getAs(key);
    }

    public Boolean getAsBoolean(String key) {
        return (Boolean)this.getAs(key);
    }

    @Override
    public <T> T getOrDefault(String key, T def) {
        return (T)this.model.getOrDefault(key, def);
    }

    @Override
    public int incrAdd(String key, int delta) {
        AtomicInteger tmp = (AtomicInteger)this.model.computeIfAbsent(key, (? super K k) -> new AtomicInteger(0));
        return tmp.addAndGet(delta);
    }

    @Override
    public int incrGet(String key) {
        AtomicInteger tmp = (AtomicInteger)this.model.computeIfAbsent(key, (? super K k) -> new AtomicInteger(0));
        return tmp.get();
    }

    @Override
    public void remove(String key) {
        this.model.remove(key);
    }

    @Override
    public String getInstanceId() {
        return (String)this.getAs("instanceId");
    }

    @Override
    public DamiBus eventBus() {
        return this.computeIfAbsent("eventBus", k -> Dami.newBus());
    }
}

