/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.flow.ChainDecl;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.NodeDecl;
import org.noear.solon.flow.NodeType;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public class Chain {
    private final ChainDecl decl;
    private Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    private List<Link> links = new ArrayList<Link>();
    private Node start;

    protected Chain(ChainDecl decl) {
        this.decl = decl;
        for (Map.Entry<String, NodeDecl> kv : decl.nodes.entrySet()) {
            this.addNode(kv.getValue());
        }
        this.check();
    }

    public String getId() {
        return this.decl.id;
    }

    public String getTitle() {
        return this.decl.title;
    }

    public String getDriver() {
        return this.decl.driver;
    }

    public Map<String, Object> getMetas() {
        return this.decl.meta;
    }

    public Object getMeta(String key) {
        return this.decl.meta.get(key);
    }

    public Object getMetaOrDefault(String key, Object def) {
        return this.decl.meta.getOrDefault(key, def);
    }

    public Node getStart() {
        return this.start;
    }

    public Map<String, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    private void addNode(NodeDecl nodeDecl) {
        ArrayList<Link> linkAry = new ArrayList<Link>();
        for (LinkDecl linkSpec : nodeDecl.links) {
            linkAry.add(new Link(this, nodeDecl.id, linkSpec));
        }
        this.links.addAll(linkAry);
        Node node = new Node(this, nodeDecl, linkAry);
        this.nodes.put(node.getId(), node);
        if (nodeDecl.type == NodeType.START) {
            this.start = node;
        }
    }

    private void check() {
        if (this.start == null) {
            for (Node node : this.nodes.values()) {
                if (!Utils.isEmpty(node.getPrevLinks())) continue;
                this.start = node;
                break;
            }
        }
        if (this.start == null) {
            throw new IllegalStateException("No start node found, chain: " + this.decl);
        }
    }

    public static Chain parseByUri(String uri) {
        return Chain.parseByDecl(ChainDecl.parseByUri(uri));
    }

    public static Chain parseByText(String text) {
        return Chain.parseByDecl(ChainDecl.parseByText(text));
    }

    public static Chain parseByDecl(ChainDecl decl) {
        return new Chain(decl);
    }

    public String toYaml() {
        return this.decl.toYaml();
    }

    public String toJson() {
        return this.decl.toJson();
    }
}

