/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import org.noear.liquor.eval.Scripts;
import org.noear.solon.core.util.Assert;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowEngine;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.Temporary;
import org.noear.solon.lang.Preview;

@Preview(value="3.5")
public class FlowExchanger {
    public static final String TAG = "exchanger";
    private final transient FlowContext context;
    protected transient FlowEngine engine;
    private final transient Temporary temporary = new Temporary();
    private volatile transient boolean interrupted = false;
    private volatile transient boolean stopped = false;

    public FlowExchanger(FlowContext context) {
        Assert.notNull((Object)context, (String)"The context is null");
        this.context = context;
    }

    public FlowContext context() {
        return this.context;
    }

    public FlowEngine engine() {
        return this.engine;
    }

    public Temporary temporary() {
        return this.temporary;
    }

    public void runTask(Node node, String description) throws FlowException {
        Assert.notNull((Object)node, (String)"node is null");
        try {
            this.engine().getDriver(node.getChain()).handleTask(this, new Task(node, description));
        }
        catch (FlowException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FlowException("The task handle failed: " + node.getChain().getId() + " / " + node.getId(), e);
        }
    }

    public Object runScript(String script) throws FlowException {
        return Scripts.eval((String)script, this.context().model());
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void interrupt(boolean interrupted) {
        this.interrupted = interrupted;
    }
}

