/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.solon.flow.Chain;

public class Temporary {
    static final String ROOT = "_ROOT";
    private final Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, Stack> stacks = new ConcurrentHashMap<String, Stack>();
    private final Map<String, Object> vars = new ConcurrentHashMap<String, Object>();

    public <T> Stack<T> stack(Chain chain, String key) {
        return this.stacks.computeIfAbsent(chain.getId() + "/" + key, k -> new Stack());
    }

    public int count(Chain chain, String key) {
        return this.counts.computeIfAbsent(chain.getId() + "/" + key, k -> new AtomicInteger(0)).get();
    }

    public int count(String key) {
        return this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).get();
    }

    public void countSet(Chain chain, String key, int value) {
        this.counts.computeIfAbsent(chain.getId() + "/" + key, k -> new AtomicInteger(0)).set(value);
    }

    public void countSet(String key, int value) {
        this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).set(value);
    }

    public int countIncr(Chain chain, String key) {
        return this.counts.computeIfAbsent(chain.getId() + "/" + key, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public int countIncr(String key) {
        return this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public int countIncr(String key, int delta) {
        return this.counts.computeIfAbsent("_ROOT/" + key, k -> new AtomicInteger(0)).addAndGet(delta);
    }

    public Map<String, Object> vars() {
        return this.vars;
    }

    public String toString() {
        return "{counts=" + this.counts + ", stacks=" + this.stacks + '}';
    }
}

