/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.driver;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.flow.Container;
import org.noear.solon.flow.Evaluation;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowExchanger;
import org.noear.solon.flow.Task;
import org.noear.solon.flow.driver.AbstractFlowDriver;
import org.noear.solon.flow.stateful.StateType;
import org.noear.solon.flow.stateful.StatefulTask;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class SimpleFlowDriver
extends AbstractFlowDriver
implements FlowDriver {
    public SimpleFlowDriver() {
        this(null, null);
    }

    public SimpleFlowDriver(Evaluation evaluation) {
        super(evaluation, null);
    }

    public SimpleFlowDriver(Container container) {
        super(null, container);
    }

    public SimpleFlowDriver(Evaluation evaluation, Container container) {
        super(evaluation, container);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleTask(FlowExchanger exchanger, Task task) throws Throwable {
        if (exchanger.context().isStateful()) {
            if (exchanger.context().statefulSupporter().isAutoForward(task.getNode())) {
                StateType state = exchanger.context().statefulSupporter().stateGet(task.getNode());
                if (state == StateType.UNKNOWN || state == StateType.WAITING) {
                    this.postHandleTask(exchanger, task);
                    if (!exchanger.isStopped() && !exchanger.isInterrupted()) {
                        StatefulTask statefulNode = new StatefulTask(exchanger.engine(), task.getNode(), StateType.COMPLETED);
                        exchanger.temporary().vars().put("ACTIVITY_NODE", statefulNode);
                        exchanger.context().statefulSupporter().statePut(task.getNode(), StateType.COMPLETED);
                        return;
                    }
                    StatefulTask statefulNode = new StatefulTask(exchanger.engine(), task.getNode(), StateType.WAITING);
                    exchanger.temporary().vars().put("ACTIVITY_NODE", statefulNode);
                    exchanger.context().statefulSupporter().statePut(task.getNode(), StateType.WAITING);
                    return;
                }
                if (state == StateType.TERMINATED) {
                    StatefulTask statefulNode = new StatefulTask(exchanger.engine(), task.getNode(), StateType.TERMINATED);
                    exchanger.temporary().vars().put("ACTIVITY_NODE", statefulNode);
                    exchanger.stop();
                    return;
                }
                if (state != StateType.COMPLETED) return;
                return;
            } else {
                StateType state = exchanger.context().statefulSupporter().stateGet(task.getNode());
                List nodeList = (List)exchanger.temporary().vars().computeIfAbsent("ACTIVITY_LIST", k -> new ArrayList());
                boolean nodeListGet = (Boolean)exchanger.temporary().vars().getOrDefault("ACTIVITY_LIST_GET", false);
                if (state == StateType.UNKNOWN || state == StateType.WAITING) {
                    if (!exchanger.context().statefulSupporter().isOperatable(task.getNode())) {
                        StatefulTask statefulNode = new StatefulTask(exchanger.engine(), task.getNode(), StateType.UNKNOWN);
                        exchanger.temporary().vars().put("ACTIVITY_NODE", statefulNode);
                        nodeList.add(statefulNode);
                        exchanger.interrupt();
                        return;
                    }
                    StatefulTask statefulNode = new StatefulTask(exchanger.engine(), task.getNode(), StateType.WAITING);
                    exchanger.temporary().vars().put("ACTIVITY_NODE", statefulNode);
                    nodeList.add(statefulNode);
                    if (nodeListGet) {
                        exchanger.interrupt();
                        return;
                    }
                    exchanger.stop();
                    return;
                }
                if (state == StateType.TERMINATED) {
                    StatefulTask statefulNode = new StatefulTask(exchanger.engine(), task.getNode(), StateType.TERMINATED);
                    exchanger.temporary().vars().put("ACTIVITY_NODE", statefulNode);
                    nodeList.add(statefulNode);
                    if (nodeListGet) {
                        exchanger.interrupt();
                        return;
                    }
                    exchanger.stop();
                    return;
                }
                if (state != StateType.COMPLETED) return;
            }
            return;
        }
        this.postHandleTask(exchanger, task);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Evaluation evaluation;
        private Container container;

        public Builder evaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public Builder container(Container container) {
            this.container = container;
            return this;
        }

        public SimpleFlowDriver build() {
            return new SimpleFlowDriver(this.evaluation, this.container);
        }
    }
}

