/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow.intercept;

import java.util.List;
import java.util.function.Consumer;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.flow.FlowContext;
import org.noear.solon.flow.FlowDriver;
import org.noear.solon.flow.FlowException;
import org.noear.solon.flow.FlowExchanger;
import org.noear.solon.flow.Node;
import org.noear.solon.flow.intercept.ChainInterceptor;

public class ChainInvocation {
    private final FlowDriver driver;
    private final FlowExchanger exchanger;
    private final Node startNode;
    private final int evalDepth;
    private final List<RankEntity<ChainInterceptor>> interceptorList;
    private final Consumer<ChainInvocation> lastHandler;
    private int index;

    public ChainInvocation(FlowDriver driver, FlowExchanger exchanger, Node startNode, int evalDepth, List<RankEntity<ChainInterceptor>> interceptorList, Consumer<ChainInvocation> lastHandler) {
        this.driver = driver;
        this.exchanger = exchanger;
        this.startNode = startNode;
        this.evalDepth = evalDepth;
        this.interceptorList = interceptorList;
        this.lastHandler = lastHandler;
        this.index = 0;
    }

    public FlowDriver getDriver() {
        return this.driver;
    }

    public FlowExchanger getExchanger() {
        return this.exchanger;
    }

    public FlowContext getContext() {
        return this.exchanger.context();
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public int getEvalDepth() {
        return this.evalDepth;
    }

    public void invoke() throws FlowException {
        if (this.index < this.interceptorList.size()) {
            ((ChainInterceptor)this.interceptorList.get((int)this.index++).target).doIntercept(this);
        } else {
            this.lastHandler.accept(this);
        }
    }
}

