/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.NodeDecl;
import org.noear.solon.flow.NodeType;
import org.noear.solon.lang.Preview;
import org.yaml.snakeyaml.Yaml;

@Preview(value="3.5")
public class ChainDecl {
    protected final String id;
    protected final String title;
    protected final String driver;
    protected final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    protected final Map<String, NodeDecl> nodes = new LinkedHashMap<String, NodeDecl>();

    public ChainDecl(String id) {
        this(id, null, null);
    }

    public ChainDecl(String id, String title) {
        this(id, title, null);
    }

    public ChainDecl(String id, String title, String driver) {
        this.id = id;
        this.title = title == null ? id : title;
        this.driver = driver == null ? "" : driver;
    }

    public Chain create() {
        return new Chain(this);
    }

    public Chain create(Consumer<ChainDecl> declaration) {
        declaration.accept(this);
        return this.create();
    }

    public void removeNode(String nodeId) {
        this.nodes.remove(nodeId);
    }

    public void addNode(NodeDecl nodeDecl) {
        this.nodes.put(nodeDecl.id, nodeDecl);
    }

    public static ChainDecl copy(Chain chain) {
        return ChainDecl.parseByText(chain.toJson());
    }

    public static ChainDecl parseByUri(String uri) {
        URL url = ResourceUtil.findResource((String)uri, (boolean)false);
        if (url == null) {
            throw new IllegalArgumentException("Can't find resource: " + uri);
        }
        if (uri.endsWith(".json") || uri.endsWith(".yml") || uri.endsWith(".yaml")) {
            try {
                return ChainDecl.parseByText(ResourceUtil.getResourceAsString((URL)url));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to load resource: " + url, ex);
            }
        }
        throw new IllegalArgumentException("File format is not supported: " + uri);
    }

    public static ChainDecl parseByText(String text) {
        Object dom = new Yaml().load(text);
        return ChainDecl.parseByDom(ONode.load((Object)dom));
    }

    public static ChainDecl parseByDom(ONode dom) {
        int i;
        String id = dom.get("id").getString();
        String title = dom.get("title").getString();
        String driver = dom.get("driver").getString();
        ChainDecl chainDecl = new ChainDecl(id, title, driver);
        Map metaTmp = (Map)dom.get("meta").toObject(Map.class);
        if (Utils.isNotEmpty((Map)metaTmp)) {
            chainDecl.meta.putAll(metaTmp);
        }
        List layoutTmp = dom.contains("layout") ? dom.get("layout").ary() : dom.get("nodes").ary();
        ArrayList<NodeDecl> nodeDeclList = new ArrayList<NodeDecl>();
        NodeDecl nodesLat = null;
        for (i = layoutTmp.size(); i > 0; --i) {
            ONode n1 = (ONode)layoutTmp.get(i - 1);
            String n1_id = n1.get("id").getString();
            if (Utils.isEmpty((String)n1_id)) {
                n1_id = "n-" + i;
            }
            String n1_typeStr = n1.get("type").getString();
            NodeType n1_type = NodeType.nameOf(n1_typeStr);
            NodeDecl nodeDecl = new NodeDecl(n1_id, n1_type);
            nodeDecl.title(n1.get("title").getString());
            nodeDecl.meta((Map)n1.get("meta").toObject(Map.class));
            nodeDecl.when(n1.get("when").getString());
            nodeDecl.task(n1.get("task").getString());
            ONode linkNode = n1.get("link");
            if (linkNode.isArray()) {
                for (ONode l1 : linkNode.ary()) {
                    if (l1.isObject()) {
                        ChainDecl.addLink(nodeDecl, l1);
                        continue;
                    }
                    if (!l1.isValue()) continue;
                    nodeDecl.linkAdd(l1.getString());
                }
            } else if (linkNode.isObject()) {
                ChainDecl.addLink(nodeDecl, linkNode);
            } else if (linkNode.isValue()) {
                nodeDecl.linkAdd(linkNode.getString());
            } else if (linkNode.isNull() && nodesLat != null) {
                nodeDecl.linkAdd(nodesLat.id);
            }
            nodesLat = nodeDecl;
            nodeDeclList.add(nodeDecl);
        }
        for (i = nodeDeclList.size(); i > 0; --i) {
            chainDecl.addNode((NodeDecl)nodeDeclList.get(i - 1));
        }
        return chainDecl;
    }

    private static void addLink(NodeDecl nodeDecl, ONode l1) {
        String whenStr = l1.contains("when") ? l1.get("when").getString() : l1.get("condition").getString();
        nodeDecl.linkAdd(l1.get("nextId").getString(), ld -> ld.title(l1.get("title").getString()).meta((Map)l1.get("meta").toObject(Map.class)).when(whenStr));
    }

    public String toYaml() {
        return new Yaml().dump(this.buildDom());
    }

    public String toJson() {
        return ONode.stringify(this.buildDom());
    }

    protected Map<String, Object> buildDom() {
        LinkedHashMap<String, Object> domRoot = new LinkedHashMap<String, Object>();
        domRoot.put("id", this.id);
        if (Utils.isNotEmpty((String)this.title)) {
            domRoot.put("title", this.title);
        }
        if (Utils.isNotEmpty((String)this.driver)) {
            domRoot.put("driver", this.driver);
        }
        if (Utils.isNotEmpty(this.meta)) {
            domRoot.put("meta", this.meta);
        }
        ArrayList domNodes = new ArrayList();
        domRoot.put("layout", domNodes);
        for (Map.Entry<String, NodeDecl> kv : this.nodes.entrySet()) {
            NodeDecl node = kv.getValue();
            LinkedHashMap<String, Object> domNode = new LinkedHashMap<String, Object>();
            domNodes.add(domNode);
            domNode.put("id", node.id);
            domNode.put("type", node.type.toString().toLowerCase());
            if (Utils.isNotEmpty((String)node.title)) {
                domNode.put("title", node.title);
            }
            if (Utils.isNotEmpty(node.meta)) {
                domNode.put("meta", node.meta);
            }
            if (Utils.isNotEmpty((String)node.when)) {
                domNode.put("when", node.when);
            }
            if (Utils.isNotEmpty((String)node.task)) {
                domNode.put("task", node.task);
            }
            if (!Utils.isNotEmpty(node.links)) continue;
            ArrayList domLinks = new ArrayList();
            domNode.put("link", domLinks);
            for (LinkDecl link : node.links) {
                LinkedHashMap<String, Object> domLink = new LinkedHashMap<String, Object>();
                domLinks.add(domLink);
                domLink.put("nextId", link.nextId);
                if (Utils.isNotEmpty((String)link.title)) {
                    domLink.put("title", link.title);
                }
                if (Utils.isNotEmpty(link.meta)) {
                    domLink.put("meta", link.meta);
                }
                if (!Utils.isNotEmpty((String)link.when)) continue;
                domLink.put("when", link.when);
            }
        }
        return domRoot;
    }
}

